/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.util.TextUtils;
import com.atlassian.stash.internal.logback.LoggingConstants;
import com.atlassian.stash.internal.mail.MailLogger;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMailLogger
implements MailLogger {
    private static final Logger log = LoggerFactory.getLogger(DefaultMailLogger.class);
    private static final Logger mailLog = LoggerFactory.getLogger((String)LoggingConstants.LOGGER_MAIL);
    private final long logPauseMillis;
    private long dropped = 0L;
    private long nextLog = 0L;

    public DefaultMailLogger(int logPauseSeconds) {
        Preconditions.checkArgument((logPauseSeconds >= 0 ? 1 : 0) != 0, (Object)"mail.error.pause.log is less than 0");
        this.logPauseMillis = TimeUnit.SECONDS.toMillis(logPauseSeconds);
    }

    @Override
    public void logDebugMessage(String message, Object ... args) {
        if (this.getMailLog().isDebugEnabled()) {
            this.getMailLog().debug(message, args);
            this.flush();
        }
    }

    @Override
    public void logInfoMessage(String message, Object ... args) {
        this.getMailLog().info(message, args);
        this.flush();
    }

    @Override
    public void logWarnMessage(String message, Object ... args) {
        this.getMailLog().warn(message, args);
        this.flush();
    }

    @Override
    public void logError(String description, MailMessage mailMessage) {
        this.getMailLog().error(this.makeLogMessage(description, mailMessage));
        this.logErrors();
    }

    @Override
    public void logError(String description, MailMessage mailMessage, Exception e) {
        this.getMailLog().error(this.makeLogMessage(description, mailMessage), (Throwable)e);
        this.logErrors();
    }

    private String makeLogMessage(String description, MailMessage mailMessage) {
        StringBuilder builder = new StringBuilder(description);
        builder.append("; recipient: ").append(StringUtils.join((Iterable)mailMessage.getTo(), (String)","));
        builder.append("; subject: ").append(mailMessage.getSubject());
        if (this.getMailLog().isDebugEnabled()) {
            builder.append("; body: ").append(mailMessage.getText());
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logErrors() {
        DefaultMailLogger defaultMailLogger = this;
        synchronized (defaultMailLogger) {
            ++this.dropped;
        }
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        long dropCount = 0L;
        DefaultMailLogger defaultMailLogger = this;
        synchronized (defaultMailLogger) {
            long now = this.currentTimeMillis();
            if (now > this.nextLog) {
                dropCount = this.dropped;
                this.dropped = 0L;
                this.nextLog = now + this.logPauseMillis;
            }
        }
        if (dropCount >= 1L) {
            this.getLog().warn(dropCount + " mail " + TextUtils.pluralise((String)"message", (long)dropCount) + " not sent due to errors: see mail log for details");
        }
    }

    long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    Logger getLog() {
        return log;
    }

    Logger getMailLog() {
        return mailLog;
    }
}

