/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.license;

import com.atlassian.bitbucket.event.license.LicenseChangedEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.LicenseManager;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.extras.decoder.api.LicenseDecoder;
import com.atlassian.stash.internal.license.LicenseHelper;
import com.atlassian.stash.internal.license.SimpleDualLicense;
import com.atlassian.stash.internal.server.ApplicationProperty;
import com.atlassian.stash.internal.server.ApplicationPropertyDao;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="licenseHelper")
public class DefaultLicenseHelper
implements LicenseHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultLicenseHelper.class);
    private final LicenseDecoder licenseDecoder;
    private final LicenseManager licenseManager;
    private final ApplicationPropertyDao propertyDao;
    private final EventPublisher eventPublisher;
    private final String setupLicense;

    @Autowired
    public DefaultLicenseHelper(LicenseDecoder licenseDecoder, LicenseManager licenseManager, ApplicationPropertyDao propertyDao, EventPublisher eventPublisher, @Value(value="${setup.license:}") String setupLicense) {
        this.licenseDecoder = licenseDecoder;
        this.licenseManager = licenseManager;
        this.propertyDao = propertyDao;
        this.eventPublisher = eventPublisher;
        this.setupLicense = this.getSetupLicense(setupLicense);
    }

    public SimpleDualLicense decode(@Nonnull String license) {
        if (this.licenseDecoder.canDecode(license)) {
            try {
                AtlassianLicense decoded = this.licenseManager.getLicense(license);
                ProductLicense productLicense = decoded.getProductLicense(Product.BITBUCKET_SERVER);
                if (productLicense instanceof BitbucketServerLicense) {
                    return new SimpleDualLicense((BitbucketServerLicense)productLicense, license);
                }
                log.warn("The decoded license does not include a Stash license. Products licensed: {}", (Object)Iterables.toString((Iterable)decoded.getProductLicenses()));
                return null;
            }
            catch (Exception e) {
                log.warn("The provided license could not be decoded", (Throwable)e);
            }
        }
        throw new IllegalArgumentException();
    }

    public String get() {
        String storedLicense = this.getStoredLicense();
        return storedLicense == null && !this.propertyDao.isSetup() ? this.setupLicense : storedLicense;
    }

    public SimpleDualLicense getDecoded() {
        String encodedLicense = this.get();
        return encodedLicense == null ? null : this.decode(encodedLicense);
    }

    public boolean isClusteringEnabled(boolean defaultValue) {
        SimpleDualLicense license = this.getDecoded();
        return license == null ? defaultValue : license.isClusteringEnabled();
    }

    public void set(@Nonnull String newLicense) {
        String oldLicense = this.getStoredLicense();
        if (oldLicense == null) {
            this.propertyDao.create(new ApplicationProperty(ApplicationProperty.Key.LICENSE, newLicense));
        } else if (!oldLicense.equals(newLicense)) {
            this.propertyDao.update(new ApplicationProperty(ApplicationProperty.Key.LICENSE, newLicense));
        } else {
            return;
        }
        this.eventPublisher.publish((Object)new LicenseChangedEvent((Object)this));
    }

    private String getStoredLicense() {
        ApplicationProperty property = this.propertyDao.getById(ApplicationProperty.Key.LICENSE);
        return property == null ? null : property.getValue();
    }

    private String getSetupLicense(String setupLicense) {
        SimpleDualLicense dualLicense = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)setupLicense)) {
                dualLicense = this.decode(setupLicense);
            }
        }
        catch (IllegalArgumentException e) {
            log.warn("Ignoring supplied license as it is invalid", (Throwable)e);
        }
        return dualLicense == null ? null : setupLicense;
    }
}

