/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.bitbucket.commit.AbstractCommitCallback;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitSummary;
import com.atlassian.bitbucket.commit.SimpleCommit;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingQueueCommitCallback
extends AbstractCommitCallback {
    private static final Logger log = LoggerFactory.getLogger(BlockingQueueCommitCallback.class);
    private static final Commit FINISHED = new SimpleCommit.Builder("finished").displayId("finished").build();
    private final BlockingQueue<Commit> queue;
    private volatile boolean finished;

    public BlockingQueueCommitCallback(int queueSize) {
        Preconditions.checkArgument((queueSize > 0 ? 1 : 0) != 0);
        this.queue = new LinkedBlockingQueue<Commit>(queueSize);
    }

    public void clear() {
        this.queue.clear();
        this.finished = false;
    }

    public boolean onCommit(@Nonnull Commit commit) {
        try {
            this.queue.put(commit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("Process was interrupted while waiting for space on the callback queue to become available", (Throwable)e);
            return false;
        }
        return true;
    }

    public void onEnd(@Nonnull CommitSummary summary) throws IOException {
        try {
            if (!Thread.currentThread().isInterrupted()) {
                this.queue.offer(FINISHED, 0L, TimeUnit.MILLISECONDS);
            }
            this.finished = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("Indexing was interrupted", (Throwable)e);
        }
    }

    public Commit poll(long timeout, TimeUnit unit) throws InterruptedException {
        Commit result = this.queue.poll(this.finished ? 0L : timeout, unit);
        return result == FINISHED ? null : result;
    }
}

