/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.stash.internal.i18n.LocaleBuilder;
import com.atlassian.stash.internal.i18n.LocaleHolder;
import com.atlassian.stash.internal.language.InternalLanguageService;
import com.atlassian.stash.internal.language.Language;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.user.InternalLocaleManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component(value="localeHolder")
public class DefaultLocaleHolder
implements LocaleHolder {
    private final Logger log = LoggerFactory.getLogger(DefaultLocaleHolder.class);
    private final AuthenticationContext authenticationContext;
    private final InternalLanguageService languageService;
    private final InternalLocaleManager localeManager;
    private final InternalApplicationPropertiesService propertiesService;
    private volatile Map<Locale, Locale> installedLocales = ImmutableMap.of();

    @Autowired
    public DefaultLocaleHolder(AuthenticationContext authenticationContext, InternalLanguageService languageService, InternalApplicationPropertiesService propertiesService, InternalLocaleManager localeManager) {
        this.authenticationContext = authenticationContext;
        this.localeManager = localeManager;
        this.languageService = languageService;
        this.propertiesService = propertiesService;
    }

    @Nonnull
    public Iterable<Locale> getLocales(Locale ... overrides) {
        ArrayList<Locale> candidateLocales = new ArrayList<Locale>(Arrays.asList(overrides));
        candidateLocales.add(this.localeManager.getLocale(this.authenticationContext.getCurrentUser()));
        LocaleContext localeContext = LocaleContextHolder.getLocaleContext();
        if (localeContext != null) {
            candidateLocales.add(localeContext.getLocale());
        }
        candidateLocales.add(this.propertiesService.getLocale());
        candidateLocales.add(Locale.US);
        List<Locale> orderedLocales = new LocaleBuilder().addAll(this.findInstalledLocaleClosestMatch(candidateLocales)).build();
        this.log.trace("Calculated={} Installed={} Candidates={} Overrides={}", new Object[]{orderedLocales, this.installedLocales, candidateLocales, overrides});
        return orderedLocales;
    }

    @EventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        this.cacheLocales();
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        this.cacheLocales();
    }

    private Iterable<Locale> findInstalledLocaleClosestMatch(@Nonnull Collection<Locale> locales) {
        LinkedHashSet<Locale> higherPreference = new LinkedHashSet<Locale>();
        LinkedHashSet<Locale> lowerPreference = new LinkedHashSet<Locale>();
        for (Locale locale : locales) {
            if (locale == null) continue;
            Locale exactMatch = this.installedLocales.get(locale);
            if (exactMatch == null) {
                exactMatch = this.installedLocales.get(new Locale(locale.getLanguage()));
            }
            if (exactMatch == null) {
                lowerPreference.add(locale);
                continue;
            }
            higherPreference.add(exactMatch);
        }
        return Iterables.concat(higherPreference, lowerPreference);
    }

    @VisibleForTesting
    void cacheLocales() {
        HashMap map = Maps.newHashMap();
        for (Language lang : this.languageService.getLanguages()) {
            if (StringUtils.isEmpty((CharSequence)lang.getLocale().getCountry())) continue;
            map.put(lang.getLocale(), lang.getLocale());
            map.put(new Locale(lang.getLocale().getLanguage()), lang.getLocale());
        }
        for (Language lang : this.languageService.getLanguages()) {
            if (!StringUtils.isEmpty((CharSequence)lang.getLocale().getCountry())) continue;
            map.put(lang.getLocale(), lang.getLocale());
        }
        this.installedLocales = map;
    }
}

