/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.atlassian.stash.internal.config.ConfigurationAmendment;
import com.google.common.base.Preconditions;
import com.google.common.io.LineProcessor;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;

public class ConfigurationLineProcessor
implements LineProcessor<Void> {
    private final Writer writer;
    private final ConfigurationAmendment amendment;

    public ConfigurationLineProcessor(@Nonnull Writer writer, @Nonnull ConfigurationAmendment amendment) {
        this.writer = (Writer)Preconditions.checkNotNull((Object)writer, (Object)"writer");
        this.amendment = (ConfigurationAmendment)Preconditions.checkNotNull((Object)amendment, (Object)"amendment");
    }

    public boolean processLine(@Nonnull String line) throws IOException {
        if (this.amendment.isAmendable(line)) {
            this.amendment.amend(this.writer, line);
        } else {
            this.writeLine(line);
        }
        return true;
    }

    @Nonnull
    public Void getResult() {
        return null;
    }

    private void writeLine(@Nonnull String line) throws IOException {
        this.writer.write(line);
        this.writer.write(10);
    }
}

