/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.concurrent.PullRequestLock;
import com.atlassian.bitbucket.concurrent.RepositoryLock;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.concurrent.BootstrapLock;
import com.atlassian.stash.internal.concurrent.HazelcastPullRequestLock;
import com.atlassian.stash.internal.concurrent.HazelcastRepositoryLock;
import com.atlassian.stash.internal.concurrent.InternalLockService;
import com.atlassian.stash.internal.concurrent.LiquibaseBootstrapLock;
import com.google.common.base.Preconditions;
import com.hazelcast.core.HazelcastInstance;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=LockService.class)
@Service(value="lockService")
public class DefaultLockService
implements InternalLockService {
    private final ClusterLockService clusterLockService;
    private final HazelcastInstance hazelcast;
    private final DataSource dataSource;
    private final I18nService i18nService;

    @Autowired
    public DefaultLockService(ClusterLockService clusterLockService, HazelcastInstance hazelcast, DataSource dataSource, I18nService i18nService) {
        this.clusterLockService = clusterLockService;
        this.hazelcast = hazelcast;
        this.dataSource = dataSource;
        this.i18nService = i18nService;
    }

    @Nonnull
    @Unsecured(value="Available to all internal code and plugins")
    public Lock getLock(@Nonnull String lockName) {
        return this.clusterLockService.getLockForName((String)Preconditions.checkNotNull((Object)lockName, (Object)"lockName"));
    }

    @Nonnull
    @Unsecured(value="Available to all internal code and plugins")
    public PullRequestLock getPullRequestLock(@Nonnull String lockName) {
        return new HazelcastPullRequestLock(this.hazelcast, (String)Preconditions.checkNotNull((Object)lockName, (Object)"lockName"));
    }

    @Nonnull
    @Unsecured(value="Available to all internal code and plugins")
    public RepositoryLock getRepositoryLock(@Nonnull String lockName) {
        return new HazelcastRepositoryLock(this.hazelcast, (String)Preconditions.checkNotNull((Object)lockName, (Object)"lockName"));
    }

    @Nonnull
    @Unsecured(value="Available to internal code only")
    public BootstrapLock getBootstrapLock() {
        return new LiquibaseBootstrapLock(this.dataSource, this.i18nService);
    }
}

