/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.bitbucket.util.Operation;
import com.google.common.base.Preconditions;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import javax.annotation.Nonnull;

public class ClusterMappedLock {
    private final HazelcastInstance hazelcast;
    private final String lockPrefix;

    public ClusterMappedLock(HazelcastInstance hazelcast, String mapName) {
        this.hazelcast = hazelcast;
        this.lockPrefix = mapName + "#";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Exception> T withLock(@Nonnull String key, @Nonnull Operation<T, E> operation) throws E {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull(operation, (Object)"operation");
        ILock lock = this.hazelcast.getLock(this.lockPrefix + key);
        lock.lock();
        try {
            Object object = operation.perform();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }
}

