/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit.graph.cache;

import com.google.common.base.Preconditions;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;

public class SetPriorityBlockingQueue<T>
extends AbstractQueue<T>
implements BlockingQueue<T> {
    private final int maxSize;
    private final Comparator<T> priorityComparator;
    private final ReentrantLock lock;
    private final Condition notFull;
    private final Condition notEmpty;
    private final LinkedList<LinkedHashSet<T>> items;
    private int size;

    public SetPriorityBlockingQueue(int maxSize, Comparator<T> priorityComparator) {
        this.maxSize = maxSize;
        this.priorityComparator = priorityComparator;
        this.size = 0;
        this.lock = new ReentrantLock(true);
        this.notFull = this.lock.newCondition();
        this.notEmpty = this.lock.newCondition();
        this.items = new LinkedList();
    }

    @Override
    public boolean contains(Object o) {
        for (LinkedHashSet linkedHashSet : this.items) {
            if (!linkedHashSet.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int drainTo(@Nonnull Collection<? super T> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(@Nonnull Collection<? super T> c, int maxElements) {
        Preconditions.checkNotNull(c);
        Preconditions.checkArgument((maxElements > 0 ? 1 : 0) != 0);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int drained = 0;
            while (this.size > 0 && maxElements >= 0) {
                c.add(this.peek());
                this.dequeue();
                --maxElements;
            }
            int n = drained;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Iterator iterator = new Iterator<T>(){
                final Iterator<LinkedHashSet<T>> baseIterator;
                LinkedHashSet<T> currentBucket;
                Iterator<T> bucketIterator;
                {
                    this.baseIterator = SetPriorityBlockingQueue.this.items.iterator();
                    this.currentBucket = null;
                    this.bucketIterator = null;
                }

                @Override
                public boolean hasNext() {
                    return this.baseIterator.hasNext() || this.bucketIterator != null && this.bucketIterator.hasNext();
                }

                @Override
                public T next() {
                    if (this.bucketIterator != null && this.bucketIterator.hasNext()) {
                        return this.bucketIterator.next();
                    }
                    if (this.baseIterator.hasNext()) {
                        this.currentBucket = this.baseIterator.next();
                        this.bucketIterator = this.currentBucket.iterator();
                        if (this.bucketIterator.hasNext()) {
                            return this.bucketIterator.next();
                        }
                    }
                    return null;
                }

                @Override
                public void remove() {
                    if (this.bucketIterator != null) {
                        this.bucketIterator.remove();
                        if (this.currentBucket.isEmpty()) {
                            this.baseIterator.remove();
                        }
                        --SetPriorityBlockingQueue.this.size;
                        SetPriorityBlockingQueue.this.notFull.signal();
                    }
                }
            };
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(@Nonnull T t) {
        Preconditions.checkNotNull(t);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            FoundPosition foundPosition = this.find(t);
            if (foundPosition == FoundPosition.HIT_BEFORE) {
                this.replace(t);
                boolean bl = true;
                return bl;
            }
            if (foundPosition == FoundPosition.HIT) {
                boolean bl = true;
                return bl;
            }
            if (this.size >= this.maxSize) {
                boolean bl = false;
                return bl;
            }
            this.insert(t);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(T t, long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(t);
        long timeLeft = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            FoundPosition foundPosition = this.find(t);
            if (foundPosition == FoundPosition.HIT_BEFORE) {
                this.replace(t);
                boolean bl = true;
                return bl;
            }
            if (foundPosition == FoundPosition.HIT) {
                boolean bl = true;
                return bl;
            }
            while (this.size >= this.maxSize) {
                if (timeLeft <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                timeLeft = this.notFull.awaitNanos(timeLeft);
            }
            this.insert(t);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public T peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.size > 0) {
                Object e = this.items.peek().iterator().next();
                return (T)e;
            }
            T t = null;
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public T poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            T t = this.dequeue();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        T result;
        long timeLeft = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while ((result = this.dequeue()) == null && timeLeft > 0L) {
                timeLeft = this.notEmpty.awaitNanos(timeLeft);
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T t) throws InterruptedException {
        Preconditions.checkNotNull(t);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            FoundPosition foundPosition = this.find(t);
            if (foundPosition == FoundPosition.HIT_BEFORE) {
                this.replace(t);
            } else if (foundPosition == FoundPosition.MISS) {
                while (this.size >= this.maxSize) {
                    this.notFull.await();
                }
                this.insert(t);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.maxSize - this.size;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        Iterator i = this.items.iterator();
        while (i.hasNext()) {
            LinkedHashSet bucket = (LinkedHashSet)i.next();
            if (!bucket.remove(o)) continue;
            if (bucket.isEmpty()) {
                i.remove();
            }
            --this.size;
            this.notFull.signal();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public T take() throws InterruptedException {
        T result;
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while ((result = this.dequeue()) == null) {
                this.notEmpty.await();
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    private T dequeue() {
        T result = null;
        if (this.size > 0) {
            Set firstPriorityBucket = this.items.peek();
            Iterator i = firstPriorityBucket.iterator();
            result = (T)i.next();
            i.remove();
            if (firstPriorityBucket.isEmpty()) {
                this.items.pop();
            }
            --this.size;
            this.notFull.signal();
        }
        return result;
    }

    private FoundPosition find(T t) {
        for (LinkedHashSet linkedHashSet : this.items) {
            if (!linkedHashSet.contains(t)) continue;
            if (this.priorityComparator.compare(t, linkedHashSet.iterator().next()) < 0) {
                return FoundPosition.HIT_BEFORE;
            }
            return FoundPosition.HIT;
        }
        return FoundPosition.MISS;
    }

    private void insert(T t) {
        LinkedHashSet<T> bucket = null;
        for (int i = 0; i < this.items.size(); ++i) {
            LinkedHashSet<T> currentBucket = this.items.get(i);
            int comparison = this.priorityComparator.compare(t, currentBucket.iterator().next());
            if (comparison < 0) {
                bucket = new LinkedHashSet();
                this.items.add(i, bucket);
                break;
            }
            if (comparison != 0) continue;
            bucket = currentBucket;
            break;
        }
        if (bucket == null) {
            bucket = new LinkedHashSet<T>();
            this.items.add(bucket);
        }
        if (bucket.add(t)) {
            ++this.size;
            this.notEmpty.signal();
        }
    }

    private void replace(T t) {
        this.remove(t);
        this.insert(t);
    }

    private static enum FoundPosition {
        HIT_BEFORE,
        HIT,
        MISS;

    }
}

