/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;

public class CommitDiscussionRequest {
    private final String commitId;
    private final boolean create;
    private final int hashCode;
    private final boolean participate;
    private final Repository repository;

    private CommitDiscussionRequest(Builder builder) {
        this.commitId = builder.commitId;
        this.create = builder.create;
        this.participate = builder.participate;
        this.repository = builder.repository;
        this.hashCode = Objects.hash(this.repository.getId(), this.commitId, this.create);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CommitDiscussionRequest) {
            CommitDiscussionRequest r = (CommitDiscussionRequest)o;
            return this.repository.equals(r.getRepository()) && this.commitId.equals(r.getCommitId()) && this.create == r.isCreate();
        }
        return false;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isCreate() {
        return this.create;
    }

    public boolean isParticipate() {
        return this.participate;
    }

    public static class Builder
    extends BuilderSupport {
        private final String commitId;
        private final Repository repository;
        private boolean create;
        private boolean participate;

        public Builder(@Nonnull Repository repository, @Nonnull String commitId) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
            this.commitId = Builder.checkNotBlank((String)commitId, (String)"commitId");
        }

        @Nonnull
        public CommitDiscussionRequest build() {
            return new CommitDiscussionRequest(this);
        }

        @Nonnull
        public Builder create(boolean value) {
            this.create = value;
            return this;
        }

        @Nonnull
        public Builder participate(boolean value) {
            this.participate = value;
            return this;
        }
    }
}

