/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.bootstrap;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.license.SIDManager;
import com.atlassian.stash.internal.concurrent.InternalLockService;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="bootstrapper")
public class Bootstrapper
extends AbstractSmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(Bootstrapper.class);
    private final InternalApplicationPropertiesService propertiesService;
    private final SecurityService securityService;
    private final SIDManager sidManager;
    private final UncheckedOperation bootstrapOperation;
    private final InternalLockService lockService;

    @Autowired
    public Bootstrapper(InternalApplicationPropertiesService propertiesService, SecurityService securityService, SIDManager sidManager, @Qualifier(value="bootstrapOperation") UncheckedOperation bootstrapOperation, InternalLockService lockService) {
        this.propertiesService = propertiesService;
        this.securityService = securityService;
        this.sidManager = sidManager;
        this.bootstrapOperation = bootstrapOperation;
        this.lockService = lockService;
    }

    public int getPhase() {
        return 1;
    }

    public void start() {
        this.securityService.withPermission(Permission.SYS_ADMIN, "Bootstrap application").call(() -> {
            if (this.propertiesService.isBootstrapped()) {
                log.debug("Application already setup, skipping bootstrap");
            } else {
                this.lockService.getBootstrapLock().withLock(() -> {
                    if (this.propertiesService.isBootstrapped()) {
                        log.debug("Application already setup, skipping bootstrap");
                    } else {
                        log.debug("Performing bootstrap operation");
                        this.bootstrapOperation.perform();
                        log.debug("Finished bootstrap operation");
                    }
                    return null;
                });
            }
            this.ensureMinimalApplicationProperties();
            return null;
        });
        super.start();
    }

    protected void ensureMinimalApplicationProperties() {
        if (this.propertiesService.getServerId() == null) {
            this.lockService.getBootstrapLock().withLock(() -> {
                if (this.propertiesService.getServerId() == null) {
                    log.info("Generating unique server ID (SID)");
                    this.propertiesService.setServerId(this.sidManager.generateSID());
                }
                return null;
            });
        }
    }
}

