/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.avatar;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.stash.internal.avatar.AvatarSource;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.encoding.MessageDigestPasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;

@Component(value="urlAvatarSource")
public class UrlAvatarSource
implements AvatarSource {
    private static final Logger log = LoggerFactory.getLogger(UrlAvatarSource.class);
    private final String defaultFallbackUrl;
    private final String httpUrlFormat;
    private final String httpsUrlFormat;
    private final MessageDigestPasswordEncoder md5;

    @Autowired
    public UrlAvatarSource(@Qualifier(value="md5Encoder") MessageDigestPasswordEncoder md5, @Value(value="${avatar.url.format.http}") String httpUrlFormat, @Value(value="${avatar.url.format.https}") String httpsUrlFormat, @Value(value="${avatar.url.default}") String defaultFallbackUrl) {
        this.defaultFallbackUrl = defaultFallbackUrl;
        this.httpUrlFormat = httpUrlFormat;
        this.httpsUrlFormat = httpsUrlFormat;
        this.md5 = md5;
    }

    @Nonnull
    public String getUrlForPerson(@Nonnull Person person, @Nonnull AvatarRequest request) {
        Preconditions.checkNotNull((Object)person);
        String emailAddress = person.getEmailAddress();
        return this.getUrlForPerson(emailAddress, request);
    }

    private String encodeUrl(String url) {
        try {
            return UriUtils.encodeQueryParam((String)url, (String)"UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Failed to encode URL using UTF-8; embedding URL as-is", (Throwable)e);
            return url;
        }
    }

    private String getUrlForPerson(String emailAddress, AvatarRequest request) {
        Preconditions.checkNotNull((Object)request);
        String hash = "00000000000000000000000000000000";
        if (StringUtils.isBlank((CharSequence)emailAddress)) {
            emailAddress = "";
        } else {
            hash = this.hash(emailAddress);
        }
        String format = request.isSecure() ? this.httpsUrlFormat : this.httpUrlFormat;
        return String.format(format, hash, request.getSize(), this.encodeUrl(this.defaultFallbackUrl), emailAddress);
    }

    private String hash(String emailAddress) {
        return this.md5.encodePassword(emailAddress.toLowerCase(Locale.US), null);
    }
}

