/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.bitbucket.audit.AuditEntry;
import com.atlassian.bitbucket.audit.Priority;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.backup.BackupEvent;
import com.atlassian.bitbucket.event.license.LicenseChangedEvent;
import com.atlassian.bitbucket.event.migration.MigrationEvent;
import com.atlassian.bitbucket.event.server.ApplicationConfigurationChangedEvent;
import com.atlassian.bitbucket.event.server.MailHostConfigurationChangedEvent;
import com.atlassian.bitbucket.event.throttle.TicketRejectedEvent;
import com.atlassian.bitbucket.mail.MailHostConfiguration;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.audit.AbstractAuditEventListener;
import com.atlassian.stash.internal.audit.AuditEntryLoggingService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServerEventListener
extends AbstractAuditEventListener {
    static final String TARGET_SYSTEM = "System";

    @Autowired
    public ServerEventListener(AuditEntryLoggingService auditLoggingService, RequestManager requestManager, AuthenticationContext authContext, EventPublisher eventPublisher) {
        super(auditLoggingService, requestManager, authContext, eventPublisher);
    }

    @EventListener
    public void onApplicationConfigurationChanged(ApplicationConfigurationChangedEvent<?> event) throws Exception {
        if (event.getClass().equals(MailHostConfigurationChangedEvent.class)) {
            return;
        }
        AuditEntry auditEntry = this.createAuditEntryBuilder((ApplicationEvent)event).target(event.getProperty().name()).details(this.toValueChangedString(event.getOldValue(), event.getNewValue())).build();
        this.publish(event, auditEntry, Priority.HIGH);
    }

    @EventListener
    public void onBackup(BackupEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder((ApplicationEvent)event).target(TARGET_SYSTEM).build();
        this.publish(event, auditEntry, Priority.HIGH);
    }

    @EventListener
    public void onMailHostConfigurationChanged(MailHostConfigurationChangedEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder((ApplicationEvent)event).target(event.getProperty().name()).details(this.toValueChangedString(this.toMailConfigMap((MailHostConfiguration)event.getOldValue()), this.toMailConfigMap((MailHostConfiguration)event.getNewValue()))).build();
        this.publish(event, auditEntry, Priority.HIGH);
    }

    @EventListener
    public void onLicenseChanged(LicenseChangedEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder((ApplicationEvent)event).target(TARGET_SYSTEM).build();
        this.publish(event, auditEntry, Priority.HIGH);
    }

    @EventListener
    public void onMigration(MigrationEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder((ApplicationEvent)event).target(TARGET_SYSTEM).build();
        this.publish(event, auditEntry, Priority.HIGH);
    }

    @EventListener
    public void onTicketRejected(TicketRejectedEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuditEntryBuilder((ApplicationEvent)event).details(event.getResourceName()).target(event.getResourceName()).build();
        this.publish(event, auditEntry, Priority.LOW);
    }

    private Map<String, Object> toMailConfigMap(MailHostConfiguration value) {
        if (value == null) {
            return null;
        }
        ImmutableMap.Builder builder = ServerEventListener.getMapBuilder().put((Object)"host", (Object)value.getHostname());
        ServerEventListener.safePut(builder, "port", value.getPort());
        ServerEventListener.safePut(builder, "username", value.getUsername());
        return builder.build();
    }

    private String toValueChangedString(Object oldValue, Object newValue) throws IOException {
        HashMap map = Maps.newHashMap();
        map.put("old", oldValue);
        map.put("new", newValue);
        return this.convertToJsonString(map);
    }
}

