/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.event.repository.RepositoryAccessedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.event.user.UserCleanupEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionPredicateFactory;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.RecentlyAccessedRepositoriesService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.user.InternalRecentlyAccessedRepositoriesService;
import com.atlassian.stash.internal.user.InternalRepositoryAccess;
import com.atlassian.stash.internal.user.RepositoryAccessDao;
import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(value=RecentlyAccessedRepositoriesService.class)
@Service(value="recentlyAccessedRepositoriesService")
public class RecentlyAccessedRepositoriesServiceImpl
extends AbstractService
implements InternalRecentlyAccessedRepositoriesService {
    public static final int RETAIN_REPO_ACCESS_COUNT = 15;
    private static final Logger log = LoggerFactory.getLogger(RecentlyAccessedRepositoriesServiceImpl.class);
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final PermissionPredicateFactory permissionPredicateFactory;
    private final PermissionService permissionService;
    private final RepositoryAccessDao repositoryAccessDao;
    private final RepositoryService repositoryService;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;

    @Autowired
    public RecentlyAccessedRepositoriesServiceImpl(AuthenticationContext authenticationContext, I18nService i18nService, PermissionPredicateFactory permissionPredicateFactory, PermissionService permissionService, RepositoryAccessDao repositoryAccessDao, RepositoryService repositoryService, PlatformTransactionManager transactionManager, UserService userService) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.permissionPredicateFactory = permissionPredicateFactory;
        this.permissionService = permissionService;
        this.repositoryAccessDao = repositoryAccessDao;
        this.repositoryService = repositoryService;
        this.userService = userService;
        this.transactionTemplate = new TransactionTemplate(transactionManager);
    }

    @PreAuthorize(value="isAuthenticated()")
    @Nonnull
    public Page<Repository> findByCurrentUser(@Nonnull PageRequest pageRequest) {
        return this.findByCurrentUser(Permission.REPO_READ, pageRequest);
    }

    @PreAuthorize(value="isAuthenticated()")
    @Nonnull
    public Page<Repository> findByCurrentUser(@Nonnull Permission permission, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)permission, (Object)"permission");
        this.validateRepositoryPermission(permission);
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        Predicate predicate = this.permissionPredicateFactory.createRepositoryPermissionPredicate(permission);
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryAccessDao.findRecentRepositories(user.getId(), pageRequest, predicate));
    }

    @EventListener
    public void onRepositoryAccessed(final RepositoryAccessedEvent event) {
        if (event.getUser() != null) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction(TransactionStatus status) {
                    Repository repository = RecentlyAccessedRepositoriesServiceImpl.this.repositoryService.getById(event.getRepository().getId());
                    ApplicationUser user = RecentlyAccessedRepositoriesServiceImpl.this.userService.getUserById(event.getUser().getId());
                    RecentlyAccessedRepositoriesServiceImpl.this.repositoryAccessDao.update((Object)new InternalRepositoryAccess.Builder().lastAccessed(event.getDate()).repository(InternalConverter.convertToInternalRepository((Repository)repository)).user(InternalConverter.convertToInternalUser((ApplicationUser)user)).build());
                    return null;
                }
            });
        }
    }

    @EventListener
    public void onRepositoryDeleteRequested(RepositoryDeletionRequestedEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Repository repository = event.getRepository();
        try {
            this.repositoryAccessDao.deleteAllAccessesForRepository(repository.getId());
        }
        catch (RuntimeException e) {
            log.warn("Repository accesses for " + repository.getProject().getKey() + "/" + repository.getSlug() + " could not be deleted", (Throwable)e);
            event.cancel(this.i18nService.createKeyedMessage("bitbucket.service.recentrepositories.cleanupfailed", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
    }

    @EventListener
    public void onUserDeleted(final UserCleanupEvent event) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction(TransactionStatus status) {
                RecentlyAccessedRepositoriesServiceImpl.this.repositoryAccessDao.deleteAllAccessesForUser(event.getDeletedUser().getId());
                return null;
            }
        });
    }

    @Transactional
    public void trimForUser(@Nonnull ApplicationUser user) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        this.repositoryAccessDao.trimRecentRepositories(user.getId(), 15, access -> this.permissionService.hasRepositoryPermission(user, (Repository)access.getRepository(), Permission.REPO_READ));
    }

    private void validateRepositoryPermission(Permission permission) {
        if (!permission.isResource(Repository.class)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.recentrepositories.invalidpermission", new Object[]{permission}));
        }
    }
}

