/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.pull.PluginPullRequestCommandFactory;
import com.atlassian.bitbucket.scm.pull.PullRequestChangeCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestDiffCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.scm.pull.PullRequestMergeCommandParameters;
import com.atlassian.bitbucket.scm.pull.ScmPullRequestCommandFactory;
import java.util.Objects;
import javax.annotation.Nonnull;

public class PluginScmPullRequestCommandFactory
implements ScmPullRequestCommandFactory {
    private final PluginPullRequestCommandFactory commandFactory;
    private final PullRequest pullRequest;

    public PluginScmPullRequestCommandFactory(PullRequest pullRequest, PluginPullRequestCommandFactory commandFactory) {
        this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
        this.commandFactory = Objects.requireNonNull(commandFactory, "commandFactory");
    }

    @Nonnull
    public Command<Boolean> canMerge() {
        return this.commandFactory.canMerge(this.pullRequest);
    }

    @Nonnull
    public Command<Void> changes(@Nonnull PullRequestChangeCommandParameters parameters, @Nonnull ChangeCallback callback) {
        return this.commandFactory.changes(this.pullRequest, parameters, callback);
    }

    @Nonnull
    public Command<Void> commits(@Nonnull CommitCallback callback) {
        return this.commandFactory.commits(this.pullRequest, callback);
    }

    @Nonnull
    public Command<Void> diff(@Nonnull PullRequestDiffCommandParameters parameters, @Nonnull DiffContentCallback callback) {
        return this.commandFactory.diff(this.pullRequest, parameters, callback);
    }

    @Nonnull
    public Command<PullRequestEffectiveDiff> effectiveDiff() {
        return this.commandFactory.effectiveDiff(this.pullRequest);
    }

    @Nonnull
    public Command<Branch> merge(@Nonnull PullRequestMergeCommandParameters parameters) {
        return this.commandFactory.merge(this.pullRequest, parameters);
    }
}

