/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal.user;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.avatar.AvatarService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserEquality;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.base.Preconditions;
import java.net.URI;

public class DefaultUserProfile
implements UserProfile {
    private static final int DEFAULT_AVATAR_SIZE = 128;
    private final ApplicationUser stashUser;
    private final NavBuilder navBuilder;
    private final AvatarService avatarService;

    public DefaultUserProfile(ApplicationUser stashUser, NavBuilder navBuilder, AvatarService avatarService) {
        this.stashUser = (ApplicationUser)Preconditions.checkNotNull((Object)stashUser);
        this.navBuilder = (NavBuilder)Preconditions.checkNotNull((Object)navBuilder);
        this.avatarService = (AvatarService)Preconditions.checkNotNull((Object)avatarService);
    }

    public String getEmail() {
        return this.stashUser.getEmailAddress();
    }

    public String getFullName() {
        return this.stashUser.getDisplayName();
    }

    public UserKey getUserKey() {
        return UserKey.fromLong((long)this.stashUser.getId());
    }

    public String getUsername() {
        return this.stashUser.getName();
    }

    public URI getProfilePictureUri(int width, int height) {
        return this.getUrlForPerson(width);
    }

    public URI getProfilePictureUri() {
        return this.getUrlForPerson(128);
    }

    public URI getProfilePageUri() {
        return URI.create(this.navBuilder.user(this.stashUser).buildRelNoContext());
    }

    public ApplicationUser getUser() {
        return this.stashUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultUserProfile that = (DefaultUserProfile)o;
        return ApplicationUserEquality.equals((ApplicationUser)this.getUser(), (Object)that.getUser());
    }

    public int hashCode() {
        return this.stashUser.hashCode();
    }

    protected URI getUrlForPerson(int width) {
        boolean useHttps = this.navBuilder.buildBaseUrl().startsWith("https");
        String avatarUrl = this.avatarService.getUrlForPerson((Person)this.stashUser, new AvatarRequest(useHttps, width));
        return UrlUtils.uncheckedCreateURI((String)avatarUrl);
    }
}

