/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.pull.RescopeDetails;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeCommit;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.pull.PullRequestRescopeCommitAction;
import com.atlassian.stash.internal.pull.rescope.InternalRescopeActivityDetails;
import com.atlassian.stash.internal.pull.rescope.InternalRescopeActivityDetailsProvider;
import com.atlassian.stash.internal.pull.rescope.RescopeProcessor;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionTemplate;

public class DefaultRescopeProcessor
implements RescopeProcessor,
ScheduledJobSource {
    private static final ToRescopeCommit AS_ADDED = new ToRescopeCommit(PullRequestRescopeCommitAction.ADDED);
    private static final ToRescopeCommit AS_REMOVED = new ToRescopeCommit(PullRequestRescopeCommitAction.REMOVED);
    private static final JobId CLEANUP_JOB_ID = JobId.of((String)CleanupEmptyRescopesJob.class.getSimpleName());
    private static final JobRunnerKey CLEANUP_JOB_RUNNER_KEY = JobRunnerKey.of((String)CleanupEmptyRescopesJob.class.getName());
    private static final Logger log = LoggerFactory.getLogger(DefaultRescopeProcessor.class);
    private final PullRequestActivityDao activityDao;
    private final InternalRescopeActivityDetailsProvider detailsProvider;
    private final ExecutorService executorService;
    private final TransactionSynchronizer synchronizer;
    private final TransactionTemplate transactionTemplate;
    private long cleanupInterval;
    private volatile boolean initialized;

    public DefaultRescopeProcessor(PullRequestActivityDao activityDao, InternalRescopeActivityDetailsProvider detailsProvider, ExecutorService executorService, TransactionSynchronizer synchronizer, TransactionTemplate transactionTemplate) {
        this.activityDao = activityDao;
        this.detailsProvider = detailsProvider;
        this.executorService = executorService;
        this.synchronizer = synchronizer;
        this.transactionTemplate = transactionTemplate;
    }

    public void deleteEmptyRescopes() {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                int count = DefaultRescopeProcessor.this.activityDao.deleteEmptyRescopes();
                if (count == 0) {
                    log.debug("No empty rescopes were found");
                } else {
                    log.debug("Deleted {} empty rescope(s)", (Object)count);
                }
            }
        });
    }

    @EventListener
    public synchronized void onPluginFrameworkStarted(PluginFrameworkStartedEvent ignored) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        List ids = (List)this.transactionTemplate.execute(status -> this.activityDao.findCalculableRescopes());
        if (ids.isEmpty()) {
            log.debug("Rescope details have already been calculated for all open pull requests");
        } else {
            log.info("Scheduling detail calculation for {} pull request rescopes", (Object)ids.size());
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                this.executorService.submit(new RescopeCalculator(id));
            }
        }
    }

    @Override
    public void process(@Nonnull InternalPullRequestRescopeActivity activity) {
        this.processAll(activity.getPullRequest(), Collections.singletonList(activity));
    }

    @Override
    public void processAll(@Nonnull InternalPullRequest pullRequest, @Nonnull List<InternalPullRequestRescopeActivity> activities) {
        try (Timer ignored = TimerUtils.start((String)(this.getClass().getName() + ".processAll(...)"));){
            if (activities.isEmpty()) {
                return;
            }
            ArrayList updated = Lists.newArrayList();
            for (InternalPullRequestRescopeActivity rescope : activities) {
                if (rescope.isPrecalculated()) continue;
                InternalRescopeActivityDetails details = this.detailsProvider.getDetails(rescope);
                rescope.setAdded(details.getAdded());
                rescope.setRemoved(details.getRemoved());
                updated.add(rescope);
            }
            if (!updated.isEmpty()) {
                this.updateActivities(pullRequest, updated);
            }
        }
    }

    @Override
    public void queue(final @Nonnull InternalPullRequestRescopeActivity activity) {
        this.synchronizer.register((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                log.debug("Queuing detail processing for rescope {}", (Object)activity.getId());
                DefaultRescopeProcessor.this.executorService.submit(new RescopeCalculator(activity.getId()));
            }
        });
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.registerJobRunner(CLEANUP_JOB_RUNNER_KEY, (JobRunner)new CleanupEmptyRescopesJob());
        schedulerService.scheduleJob(CLEANUP_JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)CLEANUP_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)this.cleanupInterval, (Date)new Date(System.currentTimeMillis() + this.cleanupInterval))));
    }

    @Value(value="${pullrequest.rescope.cleanup.interval}")
    public void setCleanupInterval(long cleanupInterval) {
        this.cleanupInterval = TimeUnit.MINUTES.toMillis(cleanupInterval);
    }

    private void updateActivities(InternalPullRequest pullRequest, final List<InternalPullRequestRescopeActivity> activities) {
        try (Timer ignored = TimerUtils.start((String)(pullRequest.getGlobalId() + " - Update commits for " + activities.size() + " activities"));){
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    for (InternalPullRequestRescopeActivity activity : activities) {
                        RescopeDetails added = activity.getAdded();
                        RescopeDetails removed = activity.getRemoved();
                        InternalPullRequestRescopeActivity updated = new InternalPullRequestRescopeActivity.Builder(activity).commits((Iterable)Lists.transform((List)added.getCommits(), (Function)AS_ADDED)).commits((Iterable)Lists.transform((List)removed.getCommits(), (Function)AS_REMOVED)).totalAdded(added.getTotal()).totalRemoved(removed.getTotal()).build();
                        DefaultRescopeProcessor.this.activityDao.update((Object)updated);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            log.warn(pullRequest.getGlobalId() + ": Could not store calculated rescope details", (Throwable)e);
        }
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.unregisterJobRunner(CLEANUP_JOB_RUNNER_KEY);
    }

    private static class ToRescopeCommit
    implements Function<Commit, InternalPullRequestRescopeCommit> {
        private final PullRequestRescopeCommitAction action;

        private ToRescopeCommit(PullRequestRescopeCommitAction action) {
            this.action = action;
        }

        public InternalPullRequestRescopeCommit apply(Commit commit) {
            return new InternalPullRequestRescopeCommit.Builder().action(this.action).commitId(commit.getId()).build();
        }
    }

    private class RescopeCalculator
    implements Runnable {
        private final long activityId;

        private RescopeCalculator(long activityId) {
            this.activityId = activityId;
        }

        @Override
        public void run() {
            try (Timer ignored = TimerUtils.start((String)(this.getClass().getName() + ".run()"));){
                InternalPullRequestRescopeActivity activity = (InternalPullRequestRescopeActivity)DefaultRescopeProcessor.this.transactionTemplate.execute(status -> {
                    status.setRollbackOnly();
                    return (InternalPullRequestRescopeActivity)HibernateUtils.cast((Object)DefaultRescopeProcessor.this.activityDao.getById((Object)this.activityId), InternalPullRequestRescopeActivity.class);
                });
                if (activity != null && !activity.isPrecalculated()) {
                    DefaultRescopeProcessor.this.process(activity);
                }
            }
        }
    }

    private class CleanupEmptyRescopesJob
    implements JobRunner {
        private CleanupEmptyRescopesJob() {
        }

        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            DefaultRescopeProcessor.this.deleteEmptyRescopes();
            return JobRunnerResponse.success();
        }
    }
}

