/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestPropertyContext;
import com.atlassian.bitbucket.pull.PullRequestPropertyProvider;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="commentCountProvider")
public class CommentCountProvider
implements PullRequestPropertyProvider {
    private static final String COMMENT_COUNT = "commentCount";
    private final PullRequestActivityDao activityDao;

    @Autowired
    public CommentCountProvider(PullRequestActivityDao activityDao) {
        this.activityDao = activityDao;
    }

    public void provideProperties(@Nonnull PullRequestPropertyContext context) {
        Map<Long, PullRequest> pullRequestsById = this.indexByGlobalId((Iterable<PullRequest>)context);
        Map commentsByPullRequest = this.activityDao.countCommentsByPullRequest(pullRequestsById.keySet());
        for (Map.Entry entry : commentsByPullRequest.entrySet()) {
            Long pullRequestId = (Long)entry.getKey();
            context.setProperty(pullRequestsById.get(pullRequestId), COMMENT_COUNT, entry.getValue());
        }
    }

    private Map<Long, PullRequest> indexByGlobalId(Iterable<PullRequest> context) {
        return Maps.uniqueIndex(context, (Function)new Function<PullRequest, Long>(){

            public Long apply(PullRequest pullRequest) {
                return InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest).getGlobalId();
            }
        });
    }
}

