/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.pull.AbstractPullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestMergeActivity;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestMergeActivity;
import com.atlassian.stash.internal.pull.PullRequestActivityEnricher;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MergePullRequestActivityEnricher
implements PullRequestActivityEnricher {
    private final PullRequestActivityVisitor mergeVisitor;

    @Autowired
    public MergePullRequestActivityEnricher(CommitService commitService) {
        this.mergeVisitor = new MergeActivityVisitor(commitService);
    }

    @Override
    public void enrich(@Nonnull InternalPullRequest pullRequest, @Nonnull Iterable<InternalPullRequestActivity> activities) {
        for (InternalPullRequestActivity activity : activities) {
            activity.accept(this.mergeVisitor);
        }
    }

    private static class MergeActivityVisitor
    extends AbstractPullRequestActivityVisitor {
        private final CommitService commitService;

        private MergeActivityVisitor(CommitService commitService) {
            this.commitService = commitService;
        }

        public void visit(@Nonnull PullRequestMergeActivity activity) {
            InternalPullRequestMergeActivity mergeActivity = (InternalPullRequestMergeActivity)activity;
            String mergeHash = mergeActivity.getHash();
            if (mergeHash != null && mergeActivity.getCommit() == null) {
                Commit mergeCommit = this.commitService.getCommit(new CommitRequest.Builder((Repository)mergeActivity.getPullRequest().getScopeRepository(), mergeHash).build());
                mergeActivity.setCommit(mergeCommit);
            }
        }
    }
}

