/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.ui.ContextualFormFragment;
import com.atlassian.bitbucket.ui.PluginFormFragments;
import com.atlassian.bitbucket.ui.PluginFormFragmentsFactory;
import com.atlassian.bitbucket.ui.ValidationErrors;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.bitbucket.view.ViewStreamIOException;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.internal.plugin.FormFragmentModuleDescriptor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=PluginFormFragmentsFactory.class)
@Component(value="pluginFormFragmentsFactory")
public class PluginFormFragmentsFactoryImpl
implements PluginFormFragmentsFactory {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginFormFragmentsFactoryImpl(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public boolean existsForKey(@Nonnull String formKey) {
        Preconditions.checkNotNull((Object)formKey, (Object)"formKey");
        return Iterables.any(this.getFormFragmentDescriptors(), descriptor -> formKey.equals(descriptor.getLocation()));
    }

    @Nonnull
    public PluginFormFragments forKey(final @Nonnull String formKey, final @Nonnull Map<String, Object> context) {
        Preconditions.checkNotNull((Object)formKey, (Object)"formKey");
        Preconditions.checkNotNull(context, (Object)"context");
        Stream<FormFragmentModuleDescriptor> descriptors = this.getFormFragmentDescriptors().stream().filter(new Predicate<FormFragmentModuleDescriptor>(){
            private final Map<String, Object> immutableContext;
            {
                this.immutableContext = Collections.unmodifiableMap(context);
            }

            @Override
            public boolean test(FormFragmentModuleDescriptor descriptor) {
                if (formKey.equals(descriptor.getLocation())) {
                    Condition condition = descriptor.getCondition();
                    return condition == null || condition.shouldDisplay(this.immutableContext);
                }
                return false;
            }
        });
        return new PluginFormFragmentsImpl(ModuleDescriptorUtils.toSortedModules(descriptors).collect(Collectors.toList()), context);
    }

    private List<FormFragmentModuleDescriptor> getFormFragmentDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(FormFragmentModuleDescriptor.class);
    }

    private static class PluginFormFragmentsImpl
    implements PluginFormFragments {
        private final Map<String, Object> context;
        private final Iterable<ContextualFormFragment> formHandlers;

        private PluginFormFragmentsImpl(Iterable<ContextualFormFragment> formHandlers, Map<String, Object> context) {
            this.context = context;
            this.formHandlers = ImmutableList.copyOf(formHandlers);
        }

        public void execute(Map<String, String[]> requestParams) {
            for (ContextualFormFragment fragment : this.formHandlers) {
                fragment.execute(requestParams, this.newContext());
            }
        }

        public String getErrorHtml(Map<String, String[]> requestParams, Map<String, Collection<String>> fieldErrors) {
            StringBuilder fieldsHtml = new StringBuilder();
            for (ContextualFormFragment fragment : this.formHandlers) {
                try {
                    fragment.doError((Appendable)fieldsHtml, requestParams, fieldErrors, this.newContext());
                }
                catch (IOException e) {
                    throw new ViewStreamIOException("Failed to render FormFragment doError: " + fragment, (Throwable)e);
                }
            }
            return fieldsHtml.toString();
        }

        public String getViewHtml() {
            StringBuilder fieldsHtml = new StringBuilder();
            for (ContextualFormFragment fragment : this.formHandlers) {
                try {
                    fragment.doView((Appendable)fieldsHtml, this.newContext());
                }
                catch (IOException e) {
                    throw new ViewStreamIOException("Failed to render FormFragment doView: " + fragment, (Throwable)e);
                }
            }
            return fieldsHtml.toString();
        }

        public void validate(Map<String, String[]> requestParams, ValidationErrors errors) {
            for (ContextualFormFragment fragment : this.formHandlers) {
                fragment.validate(requestParams, errors, this.newContext());
            }
        }

        private Map<String, Object> newContext() {
            return new HashMap<String, Object>(this.context);
        }
    }
}

