/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification;

import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.notification.Notification;
import com.atlassian.bitbucket.notification.commit.CommitDiscussionNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestReviewedNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestReviewerAddedNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestReviewersUpdatedNotification;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.notification.NotificationAddresser;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcherService;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WatcherNotificationAddresser
implements NotificationAddresser {
    private static final Logger log = LoggerFactory.getLogger(WatcherNotificationAddresser.class);
    private final InternalWatcherService watcherService;
    private final PermissionService permissionService;

    @Autowired
    public WatcherNotificationAddresser(InternalWatcherService watcherService, PermissionService permissionService) {
        this.watcherService = watcherService;
        this.permissionService = permissionService;
    }

    @Override
    public Iterable<ApplicationUser> getRecipients(Notification notification) {
        if (notification instanceof PullRequestNotification) {
            if (notification instanceof PullRequestReviewerAddedNotification) {
                return ((PullRequestReviewerAddedNotification)notification).getAddedReviewers();
            }
            if (notification instanceof PullRequestReviewersUpdatedNotification) {
                ApplicationUser author = ((PullRequestNotification)notification).getPullRequest().getAuthor().getUser();
                if (author.equals(notification.getUser())) {
                    return Collections.emptyList();
                }
                return ImmutableList.of((Object)author);
            }
            InternalPullRequest internalPullRequest = InternalConverter.convertToInternalPullRequest((PullRequest)((PullRequestNotification)notification).getPullRequest());
            if (notification instanceof PullRequestReviewedNotification) {
                return this.filterRecipients((InternalWatchable)internalPullRequest, Collections.singleton(internalPullRequest.getAuthor().getUser()));
            }
            return this.getFilteredWatchers((InternalWatchable)internalPullRequest);
        }
        if (notification instanceof CommitDiscussionNotification) {
            InternalCommitDiscussion internalCommitDiscussion = InternalConverter.convertToInternalCommitDiscussion((CommitDiscussion)((CommitDiscussionNotification)notification).getCommitDiscussion());
            return this.getFilteredWatchers((InternalWatchable)internalCommitDiscussion);
        }
        return Collections.emptyList();
    }

    private Iterable<ApplicationUser> getFilteredWatchers(InternalWatchable watchable) {
        Set watchers = (Set)this.watcherService.findWatchers((Watchable)watchable).stream().map(Watcher::getUser).collect(MoreCollectors.toImmutableSet());
        return this.filterRecipients(watchable, watchers);
    }

    private Iterable<ApplicationUser> filterRecipients(InternalWatchable watchable, Set<ApplicationUser> watchers) {
        InternalRepository repository = watchable.getScopeRepository();
        Predicate<ApplicationUser> permsCheck = arg_0 -> this.lambda$filterRecipients$0((Repository)repository, arg_0);
        return (Iterable)watchers.stream().filter(permsCheck).collect(MoreCollectors.toImmutableSet());
    }

    private /* synthetic */ boolean lambda$filterRecipients$0(Repository repository, ApplicationUser user) {
        boolean hasEmail = StringUtils.isNotEmpty((CharSequence)user.getEmailAddress());
        boolean licensed = this.permissionService.hasGlobalPermission(user, Permission.LICENSED_USER);
        boolean hasRead = this.permissionService.hasRepositoryPermission(user, repository, Permission.REPO_READ);
        if (!(!log.isDebugEnabled() || hasEmail && licensed && hasRead)) {
            log.debug("Notification not being sent to {}: hasEmailAddress: {} licensed: {} hasReadOn({}/{}): {}", new Object[]{user.getName(), hasEmail, licensed, repository.getProject().getKey(), repository.getSlug(), hasRead});
        }
        return hasEmail && licensed && hasRead;
    }
}

