/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.json;

import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.json.marshal.JsonableMarshaller;
import com.atlassian.plugin.spring.AvailableToPlugins;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins(value=JsonableMarshaller.class)
public class JsonRendererMarshaller
implements JsonableMarshaller {
    private final JsonRenderer jsonRenderer;

    @Autowired
    public JsonRendererMarshaller(JsonRenderer jsonRenderer) {
        this.jsonRenderer = jsonRenderer;
    }

    public Jsonable marshal(final Object object) {
        if (object instanceof Jsonable) {
            return (Jsonable)object;
        }
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                writer.append(JsonRendererMarshaller.this.jsonRenderer.render(object, Collections.emptyMap()));
            }
        };
    }
}

