/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.atlassian.stash.internal.config.ConfigurationMigrationException;
import com.atlassian.stash.internal.home.HomeDirectoryDetails;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import com.google.common.io.LineProcessor;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.input.ProxyReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationMigration {
    public static final String MIGRATED_CONFIG = "stash-config.old";
    private static final Logger log = LoggerFactory.getLogger(ConfigurationMigration.class);
    private final HomeDirectoryDetails details;

    public ConfigurationMigration(HomeDirectoryDetails details) {
        this.details = details;
    }

    public void perform() {
        Path sharedHome = this.details.getSharedHome().toPath();
        Path legacyConfig = sharedHome.resolve("stash-config.properties");
        Path newConfig = sharedHome.resolve("bitbucket.properties");
        boolean migrated = false;
        try (FileChannel legacyChannel = this.openLegacyConfig(legacyConfig);
             FileLock lock = legacyChannel.tryLock();){
            if (lock == null) {
                log.error("{} could not be locked. In a clustered environment, this likely means another node in the cluster is migrating it. Allow that node to start completely and then restart this node.");
                throw new ConfigurationMigrationException("stash-config.properties could not be locked for migration.\n\nIn a clustered installation one node should be started and allowed to perform the initial migration, and then the other nodes should be started.");
            }
            try (BufferedWriter newWriter = this.openNewConfig(newConfig);){
                this.translateConfig(legacyChannel, newWriter);
            }
            migrated = true;
        }
        catch (FileNotFoundException | NoSuchFileException ignored) {
            log.trace("{} does not exist", (Object)"stash-config.properties");
        }
        catch (IOException e) {
            log.error("{} could not be migrated to {} due an I/O exception. The exception follows.", new Object[]{"stash-config.properties", "bitbucket.properties", e});
            throw new ConfigurationMigrationException("stash-config.properties could not be migrated to bitbucket.properties. Additional information about the failure is available in the logs.", (Throwable)e);
        }
        if (migrated) {
            try {
                Files.move(legacyConfig, sharedHome.resolve(MIGRATED_CONFIG), new CopyOption[0]);
            }
            catch (IOException e) {
                log.error("{} could not be renamed to {} after migration", new Object[]{"stash-config.properties", MIGRATED_CONFIG, e});
                throw new ConfigurationMigrationException("After stash-config.properties was migrated to bitbucket.properties, it could not be removed.\n\nSubsequent restarts will detect both files and fail to start. An administrator must review bitbucket.properties to ensure it has been migrated correctly, remove stash-config.properties and restart.");
            }
        }
    }

    private FileChannel openLegacyConfig(Path legacyConfig) throws IOException {
        return FileChannel.open(legacyConfig, EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE), new FileAttribute[0]);
    }

    private BufferedWriter openNewConfig(Path newConfig) throws IOException {
        try {
            return Files.newBufferedWriter(newConfig, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        catch (FileAlreadyExistsException e) {
            log.error("Both {} and {} already exist. These files will need to be manually merged by an administrator.", (Object)"stash-config.properties", (Object)"bitbucket.properties");
            throw new ConfigurationMigrationException("bitbucket.properties and stash-config.properties both exist. Their contents cannot be merged automatically. An administrator must manually merge their contents, remove stash-config.properties and restart.", (Throwable)e);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            log.error("{} could not be migrated; {} could not be created. Because the legacy settings are no longer honored, the system will be locked rather than starting up without configuration.", new Object[]{"stash-config.properties", "bitbucket.properties", e});
            throw new ConfigurationMigrationException("Settings in stash-config.properties will no longer be honored and must be migrated to bitbucket.properties, but that file could not be created. Additional information about the failure is availablein the logs.", (Throwable)e);
        }
    }

    private void translateConfig(FileChannel legacyConfig, BufferedWriter newConfig) throws IOException {
        ProxyReader proxyReader = new ProxyReader(Channels.newReader(legacyConfig, StandardCharsets.UTF_8.newDecoder(), 8192)){

            public void close() throws IOException {
            }
        };
        CharStreams.readLines((Readable)proxyReader, (LineProcessor)new TranslatingLineProcessor(newConfig));
    }

    private static class TranslatingLineProcessor
    implements LineProcessor<Void> {
        private final boolean debug;
        private final Pattern pluginProperty;
        private final Map<String, String> translatedKeys;
        private final BufferedWriter writer;
        private boolean multiLine;

        public TranslatingLineProcessor(BufferedWriter writer) {
            this.writer = writer;
            this.debug = log.isDebugEnabled();
            this.pluginProperty = Pattern.compile("plugin\\.stash-([\\w-]+)(.+)");
            this.translatedKeys = ImmutableMap.builder().put((Object)"branch-information", (Object)"branch-information").put((Object)"metrics", (Object)"metrics").put((Object)"metrics-influxdb", (Object)"metrics-influxdb").put((Object)"notification", (Object)"notification").put((Object)"readme", (Object)"readme").put((Object)"repository-ref-sync", (Object)"repository-ref-sync").put((Object)"scm-cache", (Object)"scm-cache").put((Object)"scm-git", (Object)"git").put((Object)"scm-hg", (Object)"hg").build();
        }

        public Void getResult() {
            return null;
        }

        public boolean processLine(@Nonnull String line) throws IOException {
            String oldKey;
            String newKey;
            Matcher matcher;
            if (!this.multiLine && (matcher = this.pluginProperty.matcher(line)).matches() && (newKey = this.translatedKeys.get(oldKey = matcher.group(1))) != null) {
                String newLine = "plugin.bitbucket-" + newKey + matcher.group(2);
                if (this.debug) {
                    log.debug("Migrated {}->{}:\n\tOld: {}\n\tNew: {}", new Object[]{oldKey, newKey, TranslatingLineProcessor.toKey(line), TranslatingLineProcessor.toKey(newLine)});
                }
                line = newLine;
            }
            this.writer.write(line);
            this.writer.newLine();
            this.multiLine = line.endsWith("\\");
            return true;
        }

        private static String toKey(String line) {
            int index = line.indexOf(61);
            if (index == -1 && (index = line.indexOf(58)) == -1) {
                return line;
            }
            return line.substring(0, index);
        }
    }
}

