/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit.graph.cache;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.commit.graph.CachedCommitGraphSource;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CachedCommitGraphSourcePurger
implements ScheduledJobSource {
    private static final JobRunnerKey JOB_RUNNER_KEY_VER_SYNC = JobRunnerKey.of((String)(CachedCommitGraphSourcePurger.class.getSimpleName() + ".cacheInvalidationRunner"));
    private static final JobId JOB_ID_VER_SYNC = JobId.of((String)(CachedCommitGraphSourcePurger.class.getSimpleName() + ".cacheInvalidationRunner"));
    private static final TimeUnit CACHE_INVALIDATION_INTERVAL_TIME_UNIT = TimeUnit.SECONDS;
    private final int cacheInvalidationInterval;
    private final CachedCommitGraphSource source;

    @Autowired
    public CachedCommitGraphSourcePurger(CachedCommitGraphSource source, @Value(value="${commit.graph.cache.invalidation.interval}") int cacheInvalidationInterval) {
        this.cacheInvalidationInterval = cacheInvalidationInterval;
        this.source = source;
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        long interval = CACHE_INVALIDATION_INTERVAL_TIME_UNIT.toMillis(this.cacheInvalidationInterval);
        schedulerService.registerJobRunner(JOB_RUNNER_KEY_VER_SYNC, (JobRunner)new StaleCachePurger());
        schedulerService.scheduleJob(JOB_ID_VER_SYNC, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY_VER_SYNC).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)interval, (Date)new Date(System.currentTimeMillis() + interval))));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY_VER_SYNC);
    }

    class StaleCachePurger
    implements JobRunner {
        StaleCachePurger() {
        }

        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            CachedCommitGraphSourcePurger.this.source.purgeStaleEntries();
            return JobRunnerResponse.success();
        }
    }
}

