/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.soy.renderer.CustomSoyDataMapper;
import com.google.common.base.Preconditions;
import com.hazelcast.core.Member;
import java.net.InetSocketAddress;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;

@CustomSoyDataMapper(value="ClusterNode")
public class HazelcastClusterNode
implements ClusterNode {
    private static final Comparator<? super ClusterNode> ORDERING = new Comparator<ClusterNode>(){

        @Override
        public int compare(ClusterNode left, ClusterNode right) {
            return left.getId().compareTo(right.getId());
        }
    };
    private static final Function<Member, ClusterNode> TRANSFORM = HazelcastClusterNode::new;
    public static final Function<HazelcastClusterNode, Member> TO_MEMBER = HazelcastClusterNode::getMember;
    private final Member member;
    private final String name;

    public HazelcastClusterNode(Member member) {
        this.member = (Member)Preconditions.checkNotNull((Object)member, (Object)"member");
        this.name = member.getStringAttribute("node.name");
    }

    @Nonnull
    public static ClusterNode transform(@Nonnull Member member) {
        return TRANSFORM.apply(member);
    }

    @Nonnull
    public static Set<ClusterNode> transform(@Nonnull Set<Member> members) {
        return Chainable.chain(members).transform(TRANSFORM).toSet();
    }

    @Nonnull
    public static Set<ClusterNode> sort(@Nonnull Set<ClusterNode> members) {
        return Chainable.chain(members).sort(ORDERING).toSet();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HazelcastClusterNode) {
            HazelcastClusterNode n = (HazelcastClusterNode)o;
            return this.member.equals(n.member);
        }
        return false;
    }

    @Nonnull
    public InetSocketAddress getAddress() {
        return this.member.getSocketAddress();
    }

    @Nonnull
    public String getId() {
        return this.member.getUuid();
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Member getMember() {
        return this.member;
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public boolean isLocal() {
        return this.member.localMember();
    }

    public String toString() {
        return this.getId() + " listening on " + this.getAddress();
    }
}

