/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.avatar;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.stash.internal.avatar.AvatarSource;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="webResourceAvatarSource")
public class WebResourceAvatarSource
implements AvatarSource {
    public static final String AVATAR_MODULE_KEY = "com.atlassian.bitbucket.server.bitbucket-web:avatar";
    public static final String AVATAR_RESOURCE_FORMAT = "avatar/default-avatar-%1$d.png";
    private final WebResourceUrlProvider urlProvider;
    private final NavBuilder navBuilder;

    @Autowired
    public WebResourceAvatarSource(WebResourceUrlProvider urlProvider, NavBuilder navBuilder) {
        this.urlProvider = urlProvider;
        this.navBuilder = navBuilder;
    }

    @Nonnull
    public String getUrlForPerson(@Nonnull Person person, @Nonnull AvatarRequest request) {
        int size = ((AvatarRequest)Preconditions.checkNotNull((Object)request)).getSize();
        size = size > 48 ? 128 : (size > 32 ? 48 : (size > 24 ? 32 : (size > 16 ? 24 : 16)));
        String resourceName = String.format(AVATAR_RESOURCE_FORMAT, size);
        String avatarUrl = this.urlProvider.getStaticPluginResourceUrl(AVATAR_MODULE_KEY, resourceName, UrlMode.ABSOLUTE);
        if (request.isUseConfigured()) {
            avatarUrl = UrlUtils.replaceBaseUrlWithConfigured((NavBuilder)this.navBuilder, (String)avatarUrl);
        }
        return avatarUrl;
    }
}

