/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.auth.RememberMeService;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RememberMeTokenCleanupScheduler
implements ScheduledJobSource {
    private static final JobId CLEANUP_JOB_ID = JobId.of((String)CleanupExpiredRememberMeTokensJob.class.getSimpleName());
    private static final JobRunnerKey CLEANUP_JOB_RUNNER_KEY = JobRunnerKey.of((String)CleanupExpiredRememberMeTokensJob.class.getName());
    private final RememberMeService rememberMeService;
    private long cleanupIntervalMinutes = 120L;

    @Autowired
    public RememberMeTokenCleanupScheduler(RememberMeService rememberMeService) {
        this.rememberMeService = rememberMeService;
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.registerJobRunner(CLEANUP_JOB_RUNNER_KEY, (JobRunner)new CleanupExpiredRememberMeTokensJob());
        long intervalMillis = TimeUnit.MINUTES.toMillis(this.cleanupIntervalMinutes);
        schedulerService.scheduleJob(CLEANUP_JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)CLEANUP_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)intervalMillis, (Date)new Date(System.currentTimeMillis() + intervalMillis))));
    }

    @Value(value="${auth.remember-me.token.cleanup.interval}")
    public void setCleanupInterval(long cleanupIntervalMinutes) {
        this.cleanupIntervalMinutes = Math.max(1L, cleanupIntervalMinutes);
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.unregisterJobRunner(CLEANUP_JOB_RUNNER_KEY);
    }

    private class CleanupExpiredRememberMeTokensJob
    implements JobRunner {
        private CleanupExpiredRememberMeTokensJob() {
        }

        @Nullable
        public JobRunnerResponse runJob(JobRunnerRequest request) {
            RememberMeTokenCleanupScheduler.this.rememberMeService.deleteExpiredTokens(RememberMeTokenCleanupScheduler.this.cleanupIntervalMinutes, TimeUnit.MINUTES);
            return JobRunnerResponse.success();
        }
    }
}

