/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessHandler;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.stash.internal.user.InternalUserSettingsService;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;

public class RedirectingAuthenticationSuccessHandler
implements HttpAuthenticationSuccessHandler {
    private static final String KEY_NEXT_URL = "next";
    private final NavBuilder navBuilder;
    private final InternalUserSettingsService userSettingsService;
    private final FeatureManager featureManager;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private final RequestCache requestCache = new HttpSessionRequestCache();

    public RedirectingAuthenticationSuccessHandler(@Nonnull NavBuilder navBuilder, @Nonnull InternalUserSettingsService userSettingsService, @Nonnull FeatureManager featureManager) {
        this.navBuilder = navBuilder;
        this.userSettingsService = userSettingsService;
        this.featureManager = featureManager;
    }

    public boolean onAuthenticationSuccess(@Nonnull HttpAuthenticationSuccessContext context) throws ServletException, IOException {
        if (!"form".equals(context.getMethod())) {
            return false;
        }
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        String nextUrl = this.getRedirectUrl(request);
        if (StringUtils.isNotBlank((CharSequence)nextUrl)) {
            if (savedRequest != null) {
                this.requestCache.removeRequest(request, response);
            }
        } else if (savedRequest != null) {
            nextUrl = RedirectingAuthenticationSuccessHandler.stripServletPath(savedRequest.getRedirectUrl(), this.navBuilder.buildAbsolute());
        } else if (nextUrl == null) {
            nextUrl = this.navBuilder.buildAbsolute();
        }
        nextUrl = this.resolvePendingRedirect(context.getUser(), nextUrl);
        this.redirectSafely(request, response, nextUrl);
        return true;
    }

    protected String getRedirectUrl(HttpServletRequest request) {
        return request.getParameter(KEY_NEXT_URL);
    }

    protected void redirectSafely(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        response.setHeader("Cache-Control", "private, max-age=0, no-cache");
        response.setDateHeader("Expires", 0L);
        this.redirectStrategy.sendRedirect(request, response, UrlUtils.safeUrlForRedirect((String)url, (String)this.navBuilder.buildAbsolute(), (String)this.navBuilder.buildAbsolute()));
    }

    private String contextRelative(String nextUrl) {
        String contextPath = this.navBuilder.buildRelative();
        return nextUrl.startsWith(contextPath) ? nextUrl : contextPath + nextUrl;
    }

    private String resolvePendingRedirect(ApplicationUser user, String nextUrl) {
        boolean showBitbucketUpgrade;
        UserSettings userSettings = this.userSettingsService.getUserSettings(user);
        boolean showGettingStarted = this.featureManager.isEnabled((Feature)StandardFeature.GETTING_STARTED) && (Boolean)userSettings.getBoolean("SHOW_GETTING_STARTED_PAGE").getOrElse((Object)false) != false;
        boolean bl = showBitbucketUpgrade = this.featureManager.isEnabled((Feature)StandardFeature.UPGRADE_ONBOARDING) && (Boolean)userSettings.getBoolean("SEEN_BITBUCKET_UPGRADE_PAGE").getOrElse((Object)false) == false;
        if (showGettingStarted) {
            String redirectUrl = this.contextRelative(UrlUtils.getPathAndQuery((String)nextUrl));
            nextUrl = this.navBuilder.gettingStarted().next(redirectUrl).buildRelNoContext();
        } else if (showBitbucketUpgrade) {
            String redirectUrl = this.contextRelative(UrlUtils.getPathAndQuery((String)nextUrl));
            nextUrl = this.navBuilder.upgradeOnboarding().next(redirectUrl).buildRelNoContext();
        }
        return nextUrl;
    }

    @VisibleForTesting
    static String stripServletPath(String url, String prefix) {
        String mvc = "/mvc/";
        if (url.startsWith(prefix + mvc)) {
            url = prefix + "/" + url.substring(prefix.length() + mvc.length());
        }
        return url;
    }
}

