/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.HttpAuthenticationFailureContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationFailureHandler;
import com.atlassian.bitbucket.nav.NavBuilder;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class RedirectingAuthenticationFailureHandler
implements HttpAuthenticationFailureHandler {
    private static final String[] PARAMS_TO_COPY = new String[]{"next", "embedded", "permission"};
    private final NavBuilder navBuilder;

    public RedirectingAuthenticationFailureHandler(NavBuilder navBuilder) {
        this.navBuilder = navBuilder;
    }

    public boolean onAuthenticationFailure(@Nonnull HttpAuthenticationFailureContext context) throws ServletException, IOException {
        if ("basic".equals(context.getMethod())) {
            return false;
        }
        context.getResponse().sendRedirect(this.buildRedirectUrl(context.getRequest()));
        return true;
    }

    private String buildRedirectUrl(HttpServletRequest request) {
        NavBuilder.Login login = this.navBuilder.login();
        for (String paramName : PARAMS_TO_COPY) {
            String paramValue = request.getParameter(paramName);
            if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
            login = login.withParam(paramName, paramValue);
        }
        return login.buildRelative();
    }
}

