/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.bitbucket.audit.AuditEntry;
import com.atlassian.bitbucket.audit.AuditEntryBuilder;
import com.atlassian.bitbucket.audit.AuditEntryConverter;
import com.atlassian.bitbucket.event.annotation.Audited;
import com.atlassian.bitbucket.event.audit.AuditEvent;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.audit.AbstractAuditEventPublisher;
import com.atlassian.stash.internal.audit.AuditEntryLoggingService;
import com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component(value="auditedAnnotatedEventListener")
public class AuditedAnnotatedEventListener
extends AbstractAuditEventPublisher {
    private static final Logger log = LoggerFactory.getLogger(AuditedAnnotatedEventListener.class);

    @Autowired
    public AuditedAnnotatedEventListener(EventPublisher eventPublisher, RequestManager requestManager, AuditEntryLoggingService auditLoggingService) {
        super(auditLoggingService, requestManager, null, eventPublisher);
    }

    @EventListener
    public void onEvent(Object event) throws Exception {
        Audited auditAnnotated = (Audited)AnnotationUtils.findAnnotation(event.getClass(), Audited.class);
        if (auditAnnotated != null) {
            AuditEntry entry;
            if (event instanceof AuditEvent) {
                log.warn("Got @Audited annotated AuditEvent, ignoring to prevent looping {} {}", event, event.getClass());
                return;
            }
            try {
                AuditEntryConverter converter = (AuditEntryConverter)auditAnnotated.converter().newInstance();
                AuditEntryBuilder builder = new AuditEntryBuilder();
                this.setSourceIp(builder);
                entry = converter.convert(event, builder);
            }
            catch (Exception ex) {
                throw this.logAndRethrow(event, ex);
            }
            this.publish(event, entry, Sets.newHashSet((Object[])auditAnnotated.channels()), auditAnnotated.priority());
        }
    }
}

