/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.plugin.spring.AvailableToPlugins;
import javax.annotation.Nonnull;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Service(value="permissionValidationService")
@AvailableToPlugins(value=PermissionValidationService.class)
public class PermissionValidationServiceImpl
implements PermissionValidationService {
    @PreAuthorize(value="isAuthenticated()")
    public void validateAuthenticated() throws AuthorisationException {
    }

    @PreAuthorize(value="hasGlobalPermission(#permission)")
    public void validateForGlobal(@Nonnull Permission permission) throws AuthorisationException {
    }

    @PreAuthorize(value="hasProjectPermission(#project, #permission)")
    public void validateForProject(@Nonnull Project project, @Nonnull Permission permission) {
    }

    @PreAuthorize(value="hasProjectPermission(#projectId, #permission)")
    public void validateForProject(int projectId, @Nonnull Permission permission) {
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, #permission)")
    public void validateForRepository(@Nonnull Repository repository, @Nonnull Permission permission) {
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, #permission)")
    public void validateForRepository(int repositoryId, @Nonnull Permission permission) {
    }

    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    public void validateRepositoryAccessible(@Nonnull Repository repository) {
    }

    @PreAuthorize(value="isRepositoryAccessible(#repositoryId)")
    public void validateRepositoryAccessible(int repositoryId) {
    }
}

