/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.EffectivePermission;
import com.atlassian.bitbucket.permission.EffectivePermissionsProvider;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.user.EffectivePermissionsProviderTracker;
import com.atlassian.stash.internal.user.PermissionGraphFactory;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EffectivePermissionGraphFactoryBase
implements PermissionGraphFactory {
    private static final Logger log = LoggerFactory.getLogger(EffectivePermissionGraphFactoryBase.class);
    protected final EffectivePermissionsProviderTracker permissionsProviderTracker;

    public EffectivePermissionGraphFactoryBase(EffectivePermissionsProviderTracker permissionsProviderTracker) {
        this.permissionsProviderTracker = permissionsProviderTracker;
    }

    protected Iterable<? extends EffectivePermission> getEffectivePermissions(ApplicationUser user) {
        ArrayList effectivePermissions = Lists.newArrayList();
        for (EffectivePermissionsProvider provider : this.permissionsProviderTracker.getProviders()) {
            try {
                Iterables.addAll((Collection)effectivePermissions, (Iterable)provider.getPermissions(user));
            }
            catch (Exception | NoClassDefFoundError e) {
                log.error("Failed to retrieve effective permissions from provider {}", (Object)provider.getClass().getName(), (Object)e);
            }
        }
        return effectivePermissions;
    }
}

