/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.task;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.task.InternalTask;
import com.atlassian.stash.internal.task.InternalTaskContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="taskPermissionsHelper")
public class TaskPermissionsHelper {
    private final AuthenticationContext authenticationContext;
    private final PermissionService permissionService;

    @Autowired
    public TaskPermissionsHelper(AuthenticationContext authenticationContext, PermissionService permissionService) {
        this.authenticationContext = authenticationContext;
        this.permissionService = permissionService;
    }

    public boolean hasFullPermission(InternalTaskContext context, InternalTask task) {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        return task.getAuthor().equals((Object)user) || context.getCreatedBy().equals(user);
    }

    public boolean isRepoAdmin(Repository repository) {
        return this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN);
    }
}

