/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server.analytics;

import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.plugin.OptionalPluginInformationProvider;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.server.analytics.AwsAnalytics;
import com.atlassian.stash.internal.server.analytics.AwsAnalyticsFactory;
import com.atlassian.stash.internal.server.analytics.AwsAttributesAnalyticsEvent;
import com.atlassian.stash.internal.server.analytics.ConfigAttributesAnalyticsEvent;
import com.atlassian.stash.internal.server.analytics.JavaAttributesAnalyticsEvent;
import com.atlassian.stash.internal.server.analytics.SystemAttributesAnalyticsEvent;
import com.google.common.collect.ImmutableMap;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class InstanceAnalyticsJob
implements ScheduledJobSource {
    private static final JobId INFORMATION_ANALYTICS_JOB_ID = JobId.of((String)InstanceAnalyticsJobRunner.class.getSimpleName());
    private static final JobRunnerKey INFORMATION_ANALYTICS_JOB_RUNNER_KEY = JobRunnerKey.of((String)InstanceAnalyticsJobRunner.class.getName());
    private final AwsAnalyticsFactory awsAnalyticsFactory;
    private final EventPublisher eventPublisher;
    private final LicenseService licenseService;
    private final OptionalPluginInformationProvider pluginInformationProvider;
    private final InternalProjectService projectService;
    private final ApplicationPropertiesService propertiesService;
    private final InternalPullRequestService pullRequestService;
    private final InternalRepositoryService repositoryService;
    @Value(value="${analytics.aws.enabled}")
    private boolean awsAnalyticsEnabled;
    private volatile boolean awsAnalyticsPublished;

    @Autowired
    public InstanceAnalyticsJob(AwsAnalyticsFactory awsAnalyticsFactory, EventPublisher eventPublisher, LicenseService licenseService, OptionalPluginInformationProvider pluginInformationProvider, InternalProjectService projectService, ApplicationPropertiesService propertiesService, InternalPullRequestService pullRequestService, InternalRepositoryService repositoryService) {
        this.awsAnalyticsFactory = awsAnalyticsFactory;
        this.eventPublisher = eventPublisher;
        this.licenseService = licenseService;
        this.pluginInformationProvider = pluginInformationProvider;
        this.projectService = projectService;
        this.propertiesService = propertiesService;
        this.pullRequestService = pullRequestService;
        this.repositoryService = repositoryService;
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        long interval = TimeUnit.DAYS.toMillis(1L);
        long firstRun = TimeUnit.MINUTES.toMillis(30L);
        InstanceAnalyticsJobRunner jobRunner = new InstanceAnalyticsJobRunner();
        schedulerService.registerJobRunner(INFORMATION_ANALYTICS_JOB_RUNNER_KEY, (JobRunner)jobRunner);
        schedulerService.scheduleJob(INFORMATION_ANALYTICS_JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)INFORMATION_ANALYTICS_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)interval, (Date)new Date(System.currentTimeMillis() + firstRun))));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unscheduleJob(INFORMATION_ANALYTICS_JOB_ID);
        schedulerService.unregisterJobRunner(INFORMATION_ANALYTICS_JOB_RUNNER_KEY);
    }

    private ImmutableMap.Builder addPullRequestCount(ImmutableMap.Builder<String, Object> mapBuilder) {
        Map countsByState = this.pullRequestService.getCountsByState();
        return mapBuilder.put((Object)"pullRequests", (Object)new ImmutableMap.Builder().put((Object)"declined", countsByState.get(PullRequestState.DECLINED)).put((Object)"merged", countsByState.get(PullRequestState.MERGED)).put((Object)"open", countsByState.get(PullRequestState.OPEN)).build());
    }

    private Map<String, Object> getOperatingSystemInfo() {
        try {
            Class.forName("com.sun.management.OperatingSystemMXBean");
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return ImmutableMap.of((Object)"freePhysicalMemory", (Object)osBean.getFreePhysicalMemorySize(), (Object)"totalPhysicalMemory", (Object)osBean.getTotalPhysicalMemorySize());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return ImmutableMap.of();
        }
    }

    private void publishAnalyticsEvent() {
        Runtime rt = Runtime.getRuntime();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        ImmutableMap jre = ImmutableMap.of((Object)"vendor", (Object)System.getProperty("java.vendor"), (Object)"version", (Object)System.getProperty("java.version"), (Object)"vm.name", (Object)System.getProperty("java.vm.name"), (Object)"vm.arch", (Object)System.getProperty("sun.arch.data.model"));
        ImmutableMap jvm = ImmutableMap.of((Object)"availableProcessors", (Object)rt.availableProcessors(), (Object)"freeMemory", (Object)rt.freeMemory(), (Object)"maxMemory", (Object)rt.maxMemory(), (Object)"totalMemory", (Object)rt.totalMemory(), (Object)"uptime", (Object)runtimeMXBean.getUptime());
        ImmutableMap os = ImmutableMap.of((Object)"arch", (Object)System.getProperty("os.arch"), (Object)"name", (Object)System.getProperty("os.name"), (Object)"version", (Object)System.getProperty("os.version"));
        Map<String, Object> system = this.getOperatingSystemInfo();
        ImmutableMap jdbc = ImmutableMap.of((Object)"driver", (Object)this.propertiesService.getJdbcDriver(), (Object)"version", (Object)this.propertiesService.getJdbcDriverVersion());
        int maxNumberOfUsers = -1;
        BitbucketServerLicense license = this.licenseService.get();
        if (license != null) {
            maxNumberOfUsers = license.getMaximumNumberOfUsers();
        }
        ImmutableMap.Builder usageBuilder = new ImmutableMap.Builder().put((Object)"applicationMode", (Object)this.propertiesService.getMode()).put((Object)"licensedUsers", (Object)this.licenseService.getLicensedUsersCount()).put((Object)"maxLicensedUsers", (Object)maxNumberOfUsers).put((Object)"projectCount", (Object)this.projectService.getCount()).put((Object)"repositoryCount", (Object)this.repositoryService.getCount());
        this.addPullRequestCount((ImmutableMap.Builder<String, Object>)usageBuilder);
        ImmutableMap usage = usageBuilder.build();
        if (this.awsAnalyticsEnabled && !this.awsAnalyticsPublished) {
            for (AwsAnalytics awsAnalytics : this.awsAnalyticsFactory.create()) {
                this.eventPublisher.publish((Object)new AwsAttributesAnalyticsEvent(this, awsAnalytics.getAmiId(), awsAnalytics.getInstanceType()));
            }
            this.awsAnalyticsPublished = true;
        }
        this.eventPublisher.publish((Object)new JavaAttributesAnalyticsEvent(this, (Map<String, Object>)jre, (Map<String, Object>)jvm));
        this.eventPublisher.publish((Object)new SystemAttributesAnalyticsEvent(this, (Map<String, Object>)os, system));
        this.eventPublisher.publish((Object)new ConfigAttributesAnalyticsEvent(this, (Map<String, Object>)jdbc, (Map<String, Object>)usage));
    }

    private class InstanceAnalyticsJobRunner
    implements JobRunner {
        private InstanceAnalyticsJobRunner() {
        }

        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
            if (InstanceAnalyticsJob.this.pluginInformationProvider.canCollectAnalytics()) {
                InstanceAnalyticsJob.this.publishAnalyticsEvent();
            }
            return JobRunnerResponse.success();
        }
    }
}

