/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.http;

import com.atlassian.bitbucket.scm.http.HttpRequestDetails;
import com.atlassian.bitbucket.scm.http.HttpScmRequestHandler;
import com.atlassian.bitbucket.scm.http.HttpScmRequestHandlerModuleDescriptor;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.scm.http.HttpScmRequestHandlerProvider;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="httpScmRequestHandlerProvider")
public class PluginHttpScmRequestHandlerProvider
implements HttpScmRequestHandlerProvider {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginHttpScmRequestHandlerProvider(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Nonnull
    public Optional<HttpScmRequestHandler> getHandler(HttpServletRequest request) {
        return this.getHandlers().filter(handler -> handler.supports(HttpRequestDetails.ofServletRequest((HttpServletRequest)request))).findFirst();
    }

    private Stream<HttpScmRequestHandler> getHandlers() {
        return ModuleDescriptorUtils.toSortedModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(HttpScmRequestHandlerModuleDescriptor.class));
    }
}

