/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.event.repository.RepositoryCreatedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryCreationFailedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryCreationRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryForkFailedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryForkRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryForkedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryModificationRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryModifiedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.PermissionPredicateFactory;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.AbstractRepositoryRequest;
import com.atlassian.bitbucket.repository.ForkingDisabledException;
import com.atlassian.bitbucket.repository.IllegalRepositoryStateException;
import com.atlassian.bitbucket.repository.PersonalRepositoryDisabledException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCloneLinksRequest;
import com.atlassian.bitbucket.repository.RepositoryCreateRequest;
import com.atlassian.bitbucket.repository.RepositoryCreationCanceledException;
import com.atlassian.bitbucket.repository.RepositoryDeletionCanceledException;
import com.atlassian.bitbucket.repository.RepositoryForkCanceledException;
import com.atlassian.bitbucket.repository.RepositoryForkRequest;
import com.atlassian.bitbucket.repository.RepositoryModificationCanceledException;
import com.atlassian.bitbucket.repository.RepositorySearchRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.repository.RepositoryUpdateRequest;
import com.atlassian.bitbucket.repository.RepositoryVisibility;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.DeleteCommandParameters;
import com.atlassian.bitbucket.scm.FeatureUnsupportedScmException;
import com.atlassian.bitbucket.scm.ScmFeature;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.CancelState;
import com.atlassian.bitbucket.util.NamedLink;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.SimpleCancelState;
import com.atlassian.bitbucket.util.SimpleNamedLink;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.validation.groups.Create;
import com.atlassian.bitbucket.validation.groups.Update;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Throttled;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.repository.DefaultRepositorySupplier;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.repository.RepositoryOrder;
import com.atlassian.stash.internal.repository.RepositorySearchCriteria;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.utils.process.ProcessException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(interfaces={RepositoryService.class, RepositorySupplier.class})
@Service(value="repositoryService")
public class DefaultRepositoryService
extends DefaultRepositorySupplier
implements InternalRepositoryService {
    public static final String CACHE_NAME = "com.atlassian.bitbucket.repository.RepositoryService";
    public static final String EMPTY_KEY = "empty:";
    private static final int MINIMUM_MAX_REPOSITORIES = 50;
    private static final Logger log = LoggerFactory.getLogger(DefaultRepositoryService.class);
    private final AuthenticationContext authenticationContext;
    private final CacheManager cacheManager;
    private final EventPublisher eventPublisher;
    private final ScheduledExecutorService executorService;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final InternalPermissionService permissionService;
    private final PermissionPredicateFactory predicateFactory;
    private final InternalProjectService projectService;
    private final ApplicationPropertiesService propertiesService;
    private final InternalScmService scmService;
    private final SecureTokenGenerator tokenGenerator;
    private final TransactionTemplate transactionTemplate;
    private final Validator validator;
    private int maxRepositoriesPerPage;

    @Autowired
    public DefaultRepositoryService(AuthenticationContext authenticationContext, CacheManager cacheManager, EventPublisher eventPublisher, ScheduledExecutorService executorService, FeatureManager featureManager, I18nService i18nService, PermissionPredicateFactory predicateFactory, InternalPermissionService permissionService, InternalProjectService projectService, ApplicationPropertiesService propertiesService, RepositoryDao repositoryDao, InternalScmService scmService, SecureTokenGenerator tokenGenerator, PlatformTransactionManager transactionManager, Validator validator) {
        super(repositoryDao);
        this.authenticationContext = authenticationContext;
        this.cacheManager = cacheManager;
        this.eventPublisher = eventPublisher;
        this.executorService = executorService;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.predicateFactory = predicateFactory;
        this.projectService = projectService;
        this.propertiesService = propertiesService;
        this.scmService = scmService;
        this.tokenGenerator = tokenGenerator;
        this.validator = validator;
        this.maxRepositoriesPerPage = 50;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Secured(value="by the delegated method")
    @Transactional(readOnly=true)
    public int countByProject(@Nonnull Project project) {
        return this.permissionService.getCountOfAccessibleRepositories(project);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#request.project, 'PROJECT_ADMIN')")
    @Throttled(value="scm-command")
    @Transactional
    public InternalRepository create(@Nonnull RepositoryCreateRequest request) {
        Objects.requireNonNull(request, "request");
        InternalRepository repository = this.createRepositoryInDatabase((AbstractRepositoryRequest)request, request.getProject(), request.getScmId(), null, true);
        try {
            this.createRepositoryInScm(repository);
        }
        catch (ServerException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            if (rootCause instanceof ProcessException) {
                log.debug("Could not create repository {}/{} [{}]", new Object[]{repository.getProject().getKey(), repository.getSlug(), repository.getId(), e});
                throw new ServerException(this.i18nService.createKeyedMessage("bitbucket.web.repository.create.processerror", new Object[]{repository.getName(), rootCause.getClass().getSimpleName()}));
            }
            throw e;
        }
        return repository;
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    @Transactional(propagation=Propagation.SUPPORTS)
    public void delete(@Nonnull Repository repository) {
        if (Objects.requireNonNull(repository, "repository").getState() != Repository.State.AVAILABLE) {
            throw new IllegalRepositoryStateException(this.i18nService.createKeyedMessage("bitbucket.service.repository.delete.invalidstate", new Object[]{repository.getProject().getKey(), repository.getSlug(), Repository.State.AVAILABLE, repository.getState()}));
        }
        InternalRepository internal = InternalConverter.convertToInternalRepository((Repository)repository);
        Iterable forkIds = (Iterable)this.transactionTemplate.execute(transactionStatus -> {
            this.fireRepositoryDeletionRequested((Repository)internal);
            return this.deleteInDatabase(internal);
        });
        this.executorService.submit(() -> {
            long count;
            DeleteCommandParameters.Builder builder = new DeleteCommandParameters.Builder().forkIds(forkIds);
            if (Iterables.isEmpty((Iterable)forkIds) && (count = ((Long)this.transactionTemplate.execute(status -> {
                status.setRollbackOnly();
                return this.repositoryDao.countByHierarchy(internal.getHierarchyId());
            })).longValue()) == 0L) {
                builder.lastInHierarchy();
            }
            this.scmService.delete((Repository)internal, builder.build());
        });
    }

    @Nonnull
    @Secured(value="Secured using a repository accessible predicate")
    public Page<Repository> findAll(@Nonnull PageRequest pageRequest) {
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.findAll(pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate()));
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#origin)")
    public Page<Repository> findByOrigin(@Nonnull Repository origin, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(origin, "origin");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.findByOrigin(InternalConverter.convertToInternalRepository((Repository)origin), pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate()));
    }

    @Nonnull
    @Secured(value="Secured using a repository accessible predicate")
    public Page<Repository> findByOwner(@Nonnull ApplicationUser owner, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(owner, "owner");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.findByOwner(owner.getId(), pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate()));
    }

    @Nonnull
    @Secured(value="Secured using a repository accessible predicate")
    public Page<Repository> findByProjectKey(@Nonnull String projectKey, @Nonnull PageRequest pageRequest) throws NoSuchProjectException {
        Objects.requireNonNull(projectKey, "projectKey");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        if (this.projectService.getByKey(projectKey) == null) {
            if (InternalPersonalProject.isPersonalProjectKey((String)projectKey)) {
                return PageUtils.createEmptyPage((PageRequest)pageRequest);
            }
            throw new NoSuchProjectException(this.i18nService.createKeyedMessage("bitbucket.service.project.notfound", new Object[]{projectKey}));
        }
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.findByProjectKey(projectKey, pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate()));
    }

    @PreAuthorize(value="isAuthenticated() and isRepositoryAccessible(#repository)")
    public InternalRepository findPersonalFork(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        PersonalProject personalProject = this.projectService.getPersonalProject(false);
        if (personalProject == null) {
            return null;
        }
        return this.repositoryDao.findByOriginInProject(InternalConverter.convertToInternalRepository((Repository)repository), personalProject.getId());
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    public Page<Repository> findRelated(@Nonnull Repository repository, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(repository, "repository");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.findByHierarchy(InternalConverter.convertToInternalRepository((Repository)repository), pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate()));
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#request.project, 'PROJECT_ADMIN') and hasRepositoryPermission(#request.parent, 'REPO_READ')")
    @Throttled(value="scm-command")
    @Transactional
    public InternalRepository fork(@Nonnull RepositoryForkRequest request) {
        Objects.requireNonNull(request, "request");
        Repository parent = request.getParent();
        if (!this.isForkingEnabled()) {
            throw new ForkingDisabledException(this.i18nService.createKeyedMessage("bitbucket.service.repository.forkingdisabled", new Object[0]), parent);
        }
        if (!this.scmService.isSupported(parent, ScmFeature.FORK)) {
            throw new FeatureUnsupportedScmException(this.i18nService.createKeyedMessage("bitbucket.service.repository.scm.noforkfeature", new Object[]{parent.getProject().getKey(), parent.getSlug(), this.scmService.getScmName(parent)}), parent.getScmId(), ScmFeature.FORK);
        }
        Project project = request.getProject();
        this.checkCanForkRepository(parent, project);
        if (project == null) {
            project = this.projectService.getPersonalProject();
        }
        InternalRepository repository = this.createRepositoryInDatabase((AbstractRepositoryRequest)request, project, parent.getScmId(), parent, true);
        this.createRepositoryInScm(repository);
        return repository;
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    @Transactional(propagation=Propagation.SUPPORTS)
    public Set<NamedLink> getCloneLinks(@Nonnull RepositoryCloneLinksRequest request) {
        Objects.requireNonNull(request, "request");
        Repository repository = request.getRepository();
        ApplicationUser user = request.isUseCurrentUser() ? this.authenticationContext.getCurrentUser() : request.getUser();
        return this.scmService.getProtocols(repository).stream().filter(protocol -> request.getProtocolName() == null || request.getProtocolName().equalsIgnoreCase(protocol.getName())).map(protocol -> {
            String cloneUrl = protocol.getCloneUrl(repository, user);
            return cloneUrl == null ? null : new SimpleNamedLink(cloneUrl, protocol.getName());
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Unsecured(value="Internal service method, this method is also exposed via JMX")
    public long getCount() {
        return this.repositoryDao.countAll();
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public long getSize(@Nonnull Repository repository) {
        return this.scmService.getSize(repository);
    }

    @Cacheable(key="'empty:'+#repository.id", value={"com.atlassian.bitbucket.repository.RepositoryService"})
    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean isEmpty(@Nonnull Repository repository) {
        return this.scmService.isEmpty(repository);
    }

    @Unsecured(value="Allow anonymous users to check whether forking is enabled")
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean isForkingEnabled() {
        return this.featureManager.isEnabled((Feature)StandardFeature.FORKS);
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.evictEmptyCache(event.getRepository());
    }

    @EventListener
    public void onRepositoryRefsChanged(RepositoryRefsChangedEvent event) {
        this.evictEmptyCache(event.getRepository());
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#repository.project, 'PROJECT_ADMIN')")
    @Throttled(value="scm-command")
    @Transactional
    public InternalRepository retryCreate(@Nonnull Repository repository) {
        Project project = Objects.requireNonNull(repository, "repository").getProject();
        String projectName = Objects.requireNonNull(project, "project").getName();
        String name = repository.getName();
        InternalRepository existing = this.repositoryDao.getBySlug(project.getKey(), repository.getSlug());
        if (existing == null) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.nosuchreponame", new Object[]{name, projectName});
            throw new NoSuchEntityException(message);
        }
        if (existing.getState() == Repository.State.INITIALISATION_FAILED) {
            this.repositoryDao.delete((Object)existing);
            InternalRepository newRepository = this.createRepositoryInDatabase((AbstractRepositoryRequest)new RepositoryCreateRequest.Builder((Repository)existing).build(), project, existing.getScmId(), (Repository)existing.getOrigin(), false);
            this.createRepositoryInScm(newRepository);
            existing = newRepository;
        }
        return existing;
    }

    @Unsecured(value="Permission checks are applied while searching for repositories matching the provided criteria")
    public Page<Repository> search(@Nonnull RepositorySearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        pageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        if (request.isEmpty()) {
            return PageUtils.asPageOf(Repository.class, this.findAll(pageRequest));
        }
        RepositorySearchCriteria criteria = this.createSearchCriteria(request);
        if (criteria == null) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        Predicate permissionPredicate = request.hasPermission() ? this.predicateFactory.createRepositoryPermissionPredicate(request.getPermission()) : (request.getVisibility() == RepositoryVisibility.PUBLIC ? p -> true : this.predicateFactory.createRepositoryAccessiblePredicate());
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.search(criteria, pageRequest, permissionPredicate));
    }

    @Value(value="${page.max.repositories}")
    public void setMaxRepositoriesPerPage(int maxRepositoriesPerPage) {
        this.maxRepositoriesPerPage = Math.max(maxRepositoriesPerPage, 50);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.id, 'REPO_ADMIN') and (#request.project == null or hasProjectPermission(#request.project, 'PROJECT_ADMIN'))")
    @Transactional
    public InternalRepository update(@Nonnull RepositoryUpdateRequest request) {
        Objects.requireNonNull(request, "request");
        InternalRepository repository = (InternalRepository)this.repositoryDao.getById((Object)request.getId());
        if (repository == null) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.nosuchrepo", new Object[]{request.getId()});
            throw new NoSuchEntityException(message);
        }
        InternalRepository current = repository.copy().build();
        InternalRepository updated = current.copy().forkable(request.isForkable()).publiclyAccessible(request.isPublic()).name(request.getName()).project((InternalProject)MoreObjects.firstNonNull((Object)InternalConverter.convertToInternalProject((Project)request.getProject()), (Object)repository.getProject())).build();
        ValidationUtils.validate((Validator)this.validator, (Object)updated, (Class[])new Class[]{Update.class});
        this.fireRepositoryModificationRequested((Repository)current, (Repository)updated);
        updated = (InternalRepository)this.repositoryDao.update((Object)updated);
        this.eventPublisher.publish((Object)new RepositoryModifiedEvent((Object)this, (Repository)current, (Repository)updated));
        return updated;
    }

    @Nonnull
    private InternalRepository createRepositoryInDatabase(AbstractRepositoryRequest request, Project project, String scmId, Repository parent, boolean cancelable) {
        String hierarchyId = parent == null ? this.generateToken() : parent.getHierarchyId();
        this.checkCanCreateRepository(project);
        InternalRepository repository = new InternalRepository.Builder().forkable(request.isForkable()).hierarchyId(hierarchyId).name(request.getName()).origin(InternalConverter.convertToInternalRepository((Repository)parent)).project(InternalConverter.convertToInternalProject((Project)project)).publiclyAccessible(request.isPublic()).scmId(scmId).build();
        ValidationUtils.validate((Validator)this.validator, (Object)repository, (Class[])new Class[]{Create.class});
        if (cancelable) {
            if (repository.isFork()) {
                this.fireRepositoryForkRequested((Repository)repository);
            } else {
                this.fireRepositoryCreationRequested((Repository)repository);
            }
        }
        return (InternalRepository)this.repositoryDao.create((Object)repository);
    }

    private void checkCanCreateRepository(Project project) {
        if (project.getType() == ProjectType.PERSONAL && !this.featureManager.isEnabled((Feature)StandardFeature.PERSONAL_REPOS)) {
            throw new PersonalRepositoryDisabledException(this.i18nService.createKeyedMessage("bitbucket.service.repository.create.personalrepositorydisabled", new Object[0]));
        }
    }

    private void checkCanForkRepository(Repository parent, Project project) {
        if (!parent.isForkable()) {
            throw new ForkingDisabledException(this.i18nService.createKeyedMessage("bitbucket.service.repository.notforkable", new Object[]{parent.getProject().getKey(), parent.getSlug()}), parent);
        }
        if (!(project != null && project.getType() != ProjectType.PERSONAL || this.featureManager.isEnabled((Feature)StandardFeature.PERSONAL_REPOS))) {
            throw new PersonalRepositoryDisabledException(this.i18nService.createKeyedMessage("bitbucket.service.repository.fork.personalrepositorydisabled", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRepositoryInScm(InternalRepository repository) {
        block5: {
            block4: {
                Repository.State state = Repository.State.INITIALISATION_FAILED;
                try {
                    this.validateCanCreateRepositoryOnDisk((Repository)repository);
                    Command command = repository.isFork() ? this.scmService.getCommandFactory((Repository)repository.getOrigin()).fork((Repository)repository) : this.scmService.getCommandFactory((Repository)repository).create();
                    command.call();
                    state = Repository.State.AVAILABLE;
                    repository = this.setRepositoryState(repository, state);
                    if (state != Repository.State.AVAILABLE) break block4;
                }
                catch (Throwable throwable) {
                    repository = this.setRepositoryState(repository, state);
                    if (state == Repository.State.AVAILABLE) {
                        this.eventPublisher.publish(repository.isFork() ? new RepositoryForkedEvent((Object)this, (Repository)repository) : new RepositoryCreatedEvent((Object)this, (Repository)repository));
                    } else {
                        this.eventPublisher.publish(repository.isFork() ? new RepositoryForkFailedEvent((Object)this, (Repository)repository) : new RepositoryCreationFailedEvent((Object)this, (Repository)repository));
                    }
                    throw throwable;
                }
                this.eventPublisher.publish(repository.isFork() ? new RepositoryForkedEvent((Object)this, (Repository)repository) : new RepositoryCreatedEvent((Object)this, (Repository)repository));
                break block5;
            }
            this.eventPublisher.publish(repository.isFork() ? new RepositoryForkFailedEvent((Object)this, (Repository)repository) : new RepositoryCreationFailedEvent((Object)this, (Repository)repository));
        }
    }

    private RepositorySearchCriteria createSearchCriteria(RepositorySearchRequest request) {
        RepositorySearchCriteria.Builder criteria = new RepositorySearchCriteria.Builder().name(request.getName()).projectName(request.getProjectName());
        if (request.hasVisibility()) {
            criteria.visibility(request.getVisibility());
            criteria.order(RepositoryOrder.PROJECT_NAME);
            if (!this.featureManager.isEnabled((Feature)StandardFeature.PUBLIC_ACCESS)) {
                if (request.getVisibility() == RepositoryVisibility.PUBLIC) {
                    return null;
                }
                if (request.getVisibility() == RepositoryVisibility.PRIVATE) {
                    criteria.visibility(null);
                }
            }
        } else {
            criteria.order(RepositoryOrder.REPO_NAME);
        }
        return criteria.build();
    }

    private Iterable<Integer> deleteInDatabase(InternalRepository repository) {
        Iterable forkIds = this.repositoryDao.getForkIds(repository);
        if (!Iterables.isEmpty((Iterable)forkIds)) {
            this.repositoryDao.updateOrigin(repository, repository.getOrigin());
        }
        this.repositoryDao.deleteById((Object)repository.getId());
        this.fireRepositoryDeleted(repository);
        return forkIds;
    }

    private void evictEmptyCache(Repository repository) {
        this.cacheManager.getCache(CACHE_NAME).evict((Object)(EMPTY_KEY + repository.getId()));
    }

    private void fireRepositoryCreationRequested(Repository repository) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new RepositoryCreationRequestedEvent((Object)this, repository, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.creationcanceled", new Object[0]);
            throw new RepositoryCreationCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireRepositoryDeleted(InternalRepository repository) {
        this.eventPublisher.publish((Object)new RepositoryDeletedEvent((Object)this, (Repository)repository));
    }

    private void fireRepositoryDeletionRequested(Repository repository) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new RepositoryDeletionRequestedEvent((Object)this, repository, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.deletioncanceled", new Object[0]);
            throw new RepositoryDeletionCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireRepositoryForkRequested(Repository repository) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new RepositoryForkRequestedEvent((Object)this, repository, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.forkcanceled", new Object[0]);
            throw new RepositoryForkCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireRepositoryModificationRequested(Repository current, Repository updated) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new RepositoryModificationRequestedEvent((Object)this, current, updated, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.repository.updatecanceled", new Object[0]);
            throw new RepositoryModificationCanceledException(message, cancelState.getCancelMessages());
        }
    }

    @Nonnull
    private String generateToken() {
        String token = this.tokenGenerator.generateToken();
        if (token.length() > 20) {
            token = token.substring(0, 20);
        }
        return token;
    }

    private InternalRepository setRepositoryState(InternalRepository repository, Repository.State state) {
        return (InternalRepository)this.repositoryDao.update((Object)repository.copy().state(state).build());
    }

    private void validateCanCreateRepositoryOnDisk(Repository repository) {
        File repositoryRoot = this.propertiesService.getRepositoryDir(repository);
        if (repositoryRoot.isFile()) {
            throw new IllegalRepositoryStateException(this.i18nService.createKeyedMessage("bitbucket.service.repository.createfailed.filepresent", new Object[]{repository.getName(), repositoryRoot}));
        }
        if (repositoryRoot.isDirectory()) {
            throw new IllegalRepositoryStateException(this.i18nService.createKeyedMessage("bitbucket.service.repository.createfailed.directorypresent", new Object[]{repository.getName(), repositoryRoot}));
        }
    }
}

