/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.bitbucket.concurrent.BucketProcessor;
import com.atlassian.bitbucket.concurrent.BucketedExecutor;
import com.atlassian.bitbucket.concurrent.BucketedExecutorSettings;
import com.atlassian.bitbucket.concurrent.ConcurrencyPolicy;
import com.atlassian.bitbucket.concurrent.ConcurrencyService;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalRescopeRequest;
import com.atlassian.stash.internal.pull.RescopeRequestDao;
import com.atlassian.stash.internal.pull.rescope.InternalPullRequestRescopeService;
import com.atlassian.stash.internal.pull.rescope.PullRequestRescopeTask;
import com.atlassian.stash.internal.pull.rescope.RepositoryRescopeResult;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class PullRequestRescopeBucketProcessor
extends AbstractSmartLifecycle
implements BucketProcessor<PullRequestRescopeTask> {
    private static final Logger log = LoggerFactory.getLogger(PullRequestRescopeBucketProcessor.class);
    private static final Predicate<RefChange> CHANGE_FILTER = refChange -> !StandardRefType.TAG.equals((Object)refChange.getRef().getType()) && !RefChangeType.ADD.equals((Object)refChange.getType());
    private final RescopeRequestDao dao;
    private final long delayIncrementSeconds;
    private final BucketedExecutor<PullRequestRescopeTask> executor;
    private final int maxAttempts;
    private final RepositoryService repositoryService;
    private final InternalPullRequestRescopeService rescopeService;
    private final TransactionTemplate transactionTemplate;
    private final EscalatedSecurityContext withRepoRead;

    @Autowired
    public PullRequestRescopeBucketProcessor(ConcurrencyService concurrencyService, RescopeRequestDao dao, RepositoryService repositoryService, InternalPullRequestRescopeService rescopeService, SecurityService securityService, PlatformTransactionManager transactionManager, @Value(value="${pullrequest.rescope.max.attempts}") int maxAttempts, @Value(value="${pullrequest.rescope.retry.delay.increment}") long delayIncrement, @Value(value="${pullrequest.rescope.threads}") int maxThreads) {
        this.dao = dao;
        this.delayIncrementSeconds = delayIncrement;
        this.maxAttempts = maxAttempts;
        this.repositoryService = repositoryService;
        this.rescopeService = rescopeService;
        this.executor = concurrencyService.getBucketedExecutor("pull-request-rescoping", new BucketedExecutorSettings.Builder(PullRequestRescopeTask.TO_BUCKET_ID, (BucketProcessor)this).maxAttempts(1).maxConcurrency(maxThreads, ConcurrencyPolicy.PER_NODE).build());
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.withRepoRead = securityService.withPermission(Permission.REPO_READ, ((Object)((Object)this)).getClass().getSimpleName());
    }

    public int getPhase() {
        return 1600;
    }

    @EventListener
    public void onRefsChanged(RepositoryRefsChangedEvent event) {
        Collection changes = (Collection)event.getRefChanges().stream().filter(CHANGE_FILTER).collect(MoreCollectors.toImmutableList());
        if (changes.isEmpty()) {
            return;
        }
        InternalRepository repository = InternalConverter.convertToInternalRepository((Repository)event.getRepository());
        InternalApplicationUser user = InternalConverter.convertToInternalUser((ApplicationUser)event.getUser());
        if (user == null) {
            log.warn("{}: Skipping rescopes because the triggering user could not be determined", (Object)repository);
            return;
        }
        InternalRescopeRequest.Builder builder = new InternalRescopeRequest.Builder(repository, user);
        this.transactionTemplate.execute(status -> {
            changes.stream().map(change -> builder.branchId(change.getRef().getId()).build()).forEach(arg_0 -> ((RescopeRequestDao)this.dao).create(arg_0));
            return null;
        });
        log.debug("{}: Scheduling rescope processing", (Object)repository);
        this.schedule(repository);
    }

    public void process(@Nonnull String bucketId, @Nonnull List<PullRequestRescopeTask> tasks) {
        int repositoryId = Integer.parseInt(bucketId);
        List requests = (List)this.transactionTemplate.execute(status -> this.dao.findByRepository(repositoryId));
        if (requests.isEmpty()) {
            if (log.isDebugEnabled()) {
                Repository repository = (Repository)this.withRepoRead.call(() -> this.repositoryService.getById(repositoryId));
                if (repository == null) {
                    log.debug("-/-[{}]: Rescope processing skipped due to repository deletion", (Object)repositoryId);
                } else {
                    log.debug("{}: All rescope requests have already been processed", (Object)repository);
                }
            }
            return;
        }
        InternalRepository repository = ((InternalRescopeRequest)requests.get(0)).getRepository();
        Map<String, InternalApplicationUser> branchesToUsers = PullRequestRescopeBucketProcessor.mapBranchesToUsers(requests);
        RepositoryRescopeResult result = this.rescopeService.rescope((Repository)repository, Collections.unmodifiableMap(branchesToUsers));
        this.transactionTemplate.execute(arg_0 -> this.lambda$process$6(result, tasks, branchesToUsers, repository, requests, arg_0));
        if (log.isDebugEnabled()) {
            log.debug("{}: Processed {} rescope requests: {}", new Object[]{repository, requests.size(), requests.stream().map(InternalRescopeRequest.TO_ID).collect(MoreCollectors.toImmutableList())});
        }
    }

    public void start() {
        List repositoryIds = (List)this.transactionTemplate.execute(status -> this.dao.findPendingRepositoryIds());
        Iterator iterator = repositoryIds.iterator();
        while (iterator.hasNext()) {
            int repositoryId = (Integer)iterator.next();
            this.executor.submit((Serializable)new PullRequestRescopeTask(repositoryId, 1));
        }
        log.info("Rescheduled rescope processing for {} repositories: {}", (Object)repositoryIds.size(), (Object)repositoryIds);
        super.start();
    }

    public void stop() {
        this.executor.shutdown();
        super.stop();
    }

    private static Map<String, InternalApplicationUser> mapBranchesToUsers(List<InternalRescopeRequest> requests) {
        HashMap<String, InternalApplicationUser> branchesToUsers = new HashMap<String, InternalApplicationUser>();
        for (InternalRescopeRequest request : requests) {
            String key = Strings.emptyToNull((String)request.getBranchId());
            branchesToUsers.put(key, request.getUser());
        }
        return branchesToUsers;
    }

    private long getDelayMillis(int attempt) {
        return TimeUnit.SECONDS.toMillis(Math.max(0L, (long)(attempt - 1) * this.delayIncrementSeconds));
    }

    private void schedule(InternalRepository repository) {
        this.schedule(repository, 1, 0L);
    }

    private void schedule(InternalRepository repository, int attempt, long delayMs) {
        this.executor.schedule((Serializable)new PullRequestRescopeTask(repository.getId(), attempt), delayMs, TimeUnit.MILLISECONDS);
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ Void lambda$process$6(RepositoryRescopeResult result, @Nonnull List tasks, Map branchesToUsers, InternalRepository repository, List requests, TransactionStatus status) {
        block2: {
            if (result.isDone()) break block2;
            attempt = tasks.stream().mapToInt((ToIntFunction<PullRequestRescopeTask>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, getAttempt(), (Lcom/atlassian/stash/internal/pull/rescope/PullRequestRescopeTask;)I)()).max().orElse(1) + 1;
            if (attempt <= this.maxAttempts) ** GOTO lbl8
            if (result.hasSkippedAny()) {
lbl8:
                // 2 sources

                branchesToUsers.entrySet().stream().map((Function<Map.Entry, InternalRescopeRequest>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$null$5(com.atlassian.stash.internal.repository.InternalRepository java.util.Map$Entry ), (Ljava/util/Map$Entry;)Lcom/atlassian/stash/internal/pull/InternalRescopeRequest;)((InternalRepository)repository)).forEach((Consumer<InternalRescopeRequest>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, create(java.lang.Object ), (Lcom/atlassian/stash/internal/pull/InternalRescopeRequest;)V)((RescopeRequestDao)this.dao));
                delayMs = attempt <= this.maxAttempts ? this.getDelayMillis(attempt) : InternalPullRequest.LOCK_TIMEOUT_MILLIS;
                PullRequestRescopeBucketProcessor.log.info("{}: Some pull requests were not rescoped. ({} failed, {} locked). Scheduling attempt {} in {}ms", new Object[]{repository, result.getErrorCount(), result.getSkippedCount(), attempt, delayMs});
                this.schedule(repository, attempt, delayMs);
            } else {
                PullRequestRescopeBucketProcessor.log.warn("{}: Failed to rescope one or more pull requests ({} attempts)", (Object)repository, (Object)attempt);
            }
        }
        this.dao.deleteByIds((List)requests.stream().map((Function<InternalRescopeRequest, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lcom/atlassian/stash/internal/pull/InternalRescopeRequest;)Ljava/lang/Long;)()).collect(MoreCollectors.toImmutableList()));
        return null;
    }

    private static /* synthetic */ InternalRescopeRequest lambda$null$5(InternalRepository repository, Map.Entry entry) {
        return new InternalRescopeRequest.Builder(repository, (InternalApplicationUser)entry.getValue()).branchId((String)entry.getKey()).build();
    }
}

