/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.pull.comment.drift.DriftContext;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DriftResult {
    private final Map<Long, ProcessedAnchor> processedAnchors;

    public DriftResult() {
        this.processedAnchors = Maps.newHashMap();
    }

    private DriftResult(Map<Long, ProcessedAnchor> processedAnchors) {
        this.processedAnchors = processedAnchors;
    }

    public static DriftResult forRetained(@Nonnull Iterable<InternalPullRequestDiffCommentAnchor> retainedAnchors) {
        return new DriftResult().retain(retainedAnchors);
    }

    public void applyTo(@Nonnull DriftContext driftContext) {
        Iterator<InternalPullRequestDiffCommentAnchor> anchorIterator = driftContext.iterator();
        while (anchorIterator.hasNext()) {
            InternalPullRequestDiffCommentAnchor anchor = anchorIterator.next();
            ProcessedAnchor processed = this.processedAnchors.get(anchor.getId());
            if (processed == null) continue;
            processed.applyTo(driftContext);
            anchorIterator.remove();
        }
    }

    @Nonnull
    public DriftResult drift(int drift, @Nonnull Iterable<InternalPullRequestDiffCommentAnchor> anchors) {
        for (InternalPullRequestDiffCommentAnchor anchor : anchors) {
            this.record(anchor, new DriftedAnchor(anchor, drift));
        }
        return this;
    }

    @Nonnull
    public DriftResult drift(int drift, @Nonnull InternalPullRequestDiffCommentAnchor anchor, InternalPullRequestDiffCommentAnchor ... more) {
        return this.drift(drift, (Iterable<InternalPullRequestDiffCommentAnchor>)ImmutableList.builder().add((Object)anchor).addAll((Iterable)ImmutableList.copyOf((Object[])more)).build());
    }

    @Nonnull
    public List<ProcessedAnchor> getReachableAnchors() {
        return ImmutableList.copyOf((Collection)Collections2.filter(this.getProcessedAnchors(), (Predicate)Predicates.not(OrphanedAnchor.FILTER)));
    }

    @Nonnull
    public DriftResult merge(@Nonnull DriftResult other) {
        Preconditions.checkNotNull((Object)other, (Object)"other");
        HashMap merged = Maps.newHashMap(this.processedAnchors);
        for (Map.Entry<Long, ProcessedAnchor> otherAnchor : other.processedAnchors.entrySet()) {
            ProcessedAnchor displaced = merged.put(otherAnchor.getKey(), otherAnchor.getValue());
            if (displaced == null) continue;
            throw new IllegalStateException(String.format("Anchor [%d] has been mapped to two different processing outcomes: %s and %s", otherAnchor.getKey(), otherAnchor.getValue(), displaced));
        }
        return new DriftResult(merged);
    }

    @Nonnull
    public DriftResult orphan(@Nonnull Iterable<InternalPullRequestDiffCommentAnchor> anchors) {
        for (InternalPullRequestDiffCommentAnchor anchor : anchors) {
            this.record(anchor, new OrphanedAnchor(anchor));
        }
        return this;
    }

    @Nonnull
    public DriftResult orphan(@Nonnull InternalPullRequestDiffCommentAnchor anchor, InternalPullRequestDiffCommentAnchor ... more) {
        return this.orphan((Iterable<InternalPullRequestDiffCommentAnchor>)ImmutableList.builder().add((Object)anchor).addAll((Iterable)ImmutableList.copyOf((Object[])more)).build());
    }

    @Nonnull
    public DriftResult retain(@Nonnull Iterable<InternalPullRequestDiffCommentAnchor> anchors) {
        for (InternalPullRequestDiffCommentAnchor anchor : anchors) {
            this.record(anchor, new RetainedAnchor(anchor));
        }
        return this;
    }

    @Nonnull
    public DriftResult retain(@Nonnull InternalPullRequestDiffCommentAnchor anchor, InternalPullRequestDiffCommentAnchor ... more) {
        return this.retain((Iterable<InternalPullRequestDiffCommentAnchor>)ImmutableList.builder().add((Object)anchor).addAll((Iterable)ImmutableList.copyOf((Object[])more)).build());
    }

    @Nonnull
    public DriftResult record(@Nonnull InternalPullRequestDiffCommentAnchor anchor, @Nonnull ProcessedAnchor processedAnchor) {
        Preconditions.checkNotNull((Object)anchor, (Object)"anchor");
        Preconditions.checkNotNull((Object)processedAnchor, (Object)"processedAnchor");
        Preconditions.checkNotNull((Object)anchor.getId(), (Object)"anchor.id");
        Preconditions.checkArgument((anchor.getId() == processedAnchor.getAnchor().getId() ? 1 : 0) != 0, (Object)("Cannot map processed anchor to an anchor with a different ID (was: anchor.id=" + anchor.getId() + ",processedAnchor.id=" + processedAnchor.getAnchor().getId()));
        this.processedAnchors.put(anchor.getId(), processedAnchor);
        return this;
    }

    private List<ProcessedAnchor> getProcessedAnchors() {
        return ImmutableList.copyOf(this.processedAnchors.values());
    }

    public static class RetainedAnchor
    extends ProcessedAnchor {
        private RetainedAnchor(@Nonnull InternalPullRequestDiffCommentAnchor anchor) {
            super(anchor);
        }

        @Override
        public void applyTo(@Nonnull DriftContext context) {
            context.retain(this.anchor);
        }
    }

    public static abstract class ProcessedAnchor {
        public static final Function<ProcessedAnchor, InternalPullRequestDiffCommentAnchor> TO_ANCHOR = ProcessedAnchor::getAnchor;
        protected final InternalPullRequestDiffCommentAnchor anchor;

        protected ProcessedAnchor(@Nonnull InternalPullRequestDiffCommentAnchor anchor) {
            this.anchor = (InternalPullRequestDiffCommentAnchor)Preconditions.checkNotNull((Object)anchor, (Object)"anchor");
        }

        public abstract void applyTo(@Nonnull DriftContext var1);

        @Nonnull
        public InternalPullRequestDiffCommentAnchor getAnchor() {
            return this.anchor;
        }

        public int getLine() {
            return this.anchor.getLine();
        }

        @Nullable
        public DiffSegmentType getLineType() {
            return this.anchor.getLineType();
        }

        @Nonnull
        public String getPath() {
            return this.anchor.getPath();
        }

        @Nullable
        public String getSrcPath() {
            return this.anchor.getSrcPath();
        }

        protected static <A extends ProcessedAnchor> Predicate<ProcessedAnchor> instanceOf(@Nonnull Class<A> anchorClass) {
            return Predicates.instanceOf(anchorClass);
        }
    }

    public static class OrphanedAnchor
    extends ProcessedAnchor {
        public static final Predicate<ProcessedAnchor> FILTER = OrphanedAnchor.instanceOf(OrphanedAnchor.class);

        private OrphanedAnchor(@Nonnull InternalPullRequestDiffCommentAnchor anchor) {
            super(anchor);
        }

        @Override
        public void applyTo(@Nonnull DriftContext context) {
            context.orphan(this.anchor);
        }
    }

    public static class DriftedAnchor
    extends ProcessedAnchor {
        private final int drift;

        private DriftedAnchor(@Nonnull InternalPullRequestDiffCommentAnchor anchor, int drift) {
            super(anchor);
            this.drift = drift;
        }

        @Override
        public int getLine() {
            return super.getLine() + this.drift;
        }

        @Override
        public void applyTo(@Nonnull DriftContext context) {
            context.drift(this.anchor, this.drift);
        }
    }
}

