/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mode;

import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationModeGuard {
    private final InternalApplicationPropertiesService propertiesService;
    private final ServletContext servletContext;

    @Autowired
    public ApplicationModeGuard(InternalApplicationPropertiesService propertiesService, ServletContext servletContext) {
        this.propertiesService = propertiesService;
        this.servletContext = servletContext;
    }

    @PostConstruct
    public void validate() {
        ApplicationMode currentMode = this.propertiesService.getMode();
        Optional lastKnownMode = this.propertiesService.getLastMode();
        if (!lastKnownMode.isPresent()) {
            this.propertiesService.setMode(currentMode);
            return;
        }
        lastKnownMode.ifPresent(mode -> {
            if (mode != currentMode) {
                String message = String.format("This instance must be started in '%s' mode. It is currently started in '%s' mode.", mode.toString(), currentMode.toString());
                Johnson.getEventContainer((ServletContext)this.servletContext).addEvent(new Event(EventType.get((String)"node-passivated"), message, EventLevel.get((String)"error")));
            }
        });
    }
}

