/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.backup;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.util.ProgressImpl;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.backup.BackupException;
import com.atlassian.stash.internal.config.DataSourcePropertySerializer;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.maintenance.backup.BackupState;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.common.io.Flushables;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationBackupStep
extends AbstractMaintenanceTask {
    public static final String BANNER = "#> Produced for backup from datasource configuration";
    private static final Logger log = LoggerFactory.getLogger(ConfigurationBackupStep.class);
    private final File sharedHomeDir;
    private final I18nService i18nService;
    private volatile int progress;
    private final BackupState state;

    public ConfigurationBackupStep(BackupState state, ApplicationSettings applicationSettings, I18nService i18nService) {
        this.sharedHomeDir = applicationSettings.getSharedHomeDir();
        this.i18nService = i18nService;
        this.state = state;
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.i18nService.getMessage("bitbucket.backup.configuration", new Object[]{Product.NAME}), this.progress);
    }

    public void run() {
        ZipOutputStream stream = this.state.getBackupZipStream();
        Preconditions.checkState((stream != null ? 1 : 0) != 0, (Object)"A backup ZipOutputStream is required");
        try {
            ZipEntry entry = new ZipEntry("bitbucket.properties");
            stream.putNextEntry(entry);
            log.debug("Backing up {} configuration to {}", (Object)Product.NAME, (Object)"bitbucket.properties");
            this.writeConfigurationBackup((OutputStream)new CloseShieldOutputStream((OutputStream)stream));
            stream.closeEntry();
            this.progress = 100;
        }
        catch (IOException e) {
            throw new BackupException(this.i18nService.createKeyedMessage("bitbucket.backup.configuration.failed", new Object[]{Product.NAME}), (Throwable)e);
        }
    }

    private boolean containsJdbcProperties(File config) throws IOException {
        Properties properties = new Properties();
        properties.load(Files.asByteSource((File)config).openBufferedStream());
        return properties.containsKey("jdbc.driver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfigurationBackup(OutputStream stream) throws IOException {
        File config = new File(this.sharedHomeDir, "bitbucket.properties");
        if (config.exists()) {
            Files.copy((File)config, (OutputStream)stream);
        }
        if (!config.exists() || !this.containsJdbcProperties(config)) {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
            if (config.exists()) {
                writer.write("\n");
            }
            try {
                this.writeDefaultConfiguration(writer);
            }
            finally {
                Flushables.flush((Flushable)writer, (boolean)false);
            }
        }
    }

    private void writeDefaultConfiguration(BufferedWriter writer) throws IOException {
        DataSourcePropertySerializer serializer = new DataSourcePropertySerializer(this.state.getSourceDatabase().getConfiguration());
        writer.write(BANNER);
        writer.write("\n");
        serializer.writeTo(writer);
    }
}

