/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskStatus;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskStatusSupplier;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import javax.annotation.Nonnull;

public class ClusteredMaintenanceTaskStatusSupplier
implements MaintenanceTaskStatusSupplier {
    private final MaintenanceTaskStatusSupplier delegate;
    private final ITopic<MaintenanceTaskStatus> topic;
    private volatile String listenerId;

    public ClusteredMaintenanceTaskStatusSupplier(MaintenanceTaskStatusSupplier delegate, ITopic<MaintenanceTaskStatus> topic) {
        this.delegate = delegate;
        this.topic = topic;
    }

    public void addListener() {
        this.listenerId = this.topic.addMessageListener((MessageListener)new MessageListener<MaintenanceTaskStatus>(){

            public void onMessage(Message<MaintenanceTaskStatus> message) {
                if (!message.getPublishingMember().localMember()) {
                    ClusteredMaintenanceTaskStatusSupplier.this.delegate.set((MaintenanceTaskStatus)message.getMessageObject());
                }
            }
        });
    }

    public void removeListener() {
        String listenerId = this.listenerId;
        if (listenerId != null) {
            this.topic.removeMessageListener(listenerId);
        }
    }

    @Override
    public MaintenanceTaskStatus get() {
        return this.delegate.get();
    }

    @Override
    public void set(@Nonnull MaintenanceTaskStatus status) {
        this.delegate.set(status);
        this.topic.publish((Object)status);
    }

    @EventListener
    public void onNodeAdded(ClusterNodeAddedEvent event) {
        MaintenanceTaskStatus status = this.delegate.get();
        if (status == null) {
            return;
        }
        boolean publishStatus = true;
        for (ClusterNode node : event.getCurrentNodes()) {
            if (!status.getOwnerNodeId().equals(node.getId())) continue;
            if (node.isLocal()) break;
            publishStatus = false;
            break;
        }
        if (publishStatus) {
            this.topic.publish((Object)status);
        }
    }
}

