/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.util.ProgressImpl;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.maintenance.DrainHelper;
import com.atlassian.stash.internal.maintenance.latch.Latch;
import com.atlassian.stash.internal.maintenance.latch.LatchMode;
import com.atlassian.stash.internal.maintenance.latch.LatchableService;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLatchAndDrainTask<L extends Latch>
extends AbstractMaintenanceTask {
    protected final I18nService i18nService;
    private final long drainTimeoutSeconds;
    private final long forceDrainTimeoutSeconds;
    private final LatchableService<L> latchableService;
    private final LatchMode latchMode;
    private final Logger log;
    private volatile boolean drained;
    private volatile Thread drainingThread;

    public AbstractLatchAndDrainTask(I18nService i18nService, LatchableService<L> latchableService, LatchMode latchMode, long drainTimeoutSeconds, long forceDrainTimeoutSeconds) {
        this.i18nService = i18nService;
        this.latchableService = latchableService;
        this.latchMode = latchMode;
        this.drainTimeoutSeconds = drainTimeoutSeconds;
        this.forceDrainTimeoutSeconds = forceDrainTimeoutSeconds;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public void cancel() {
        super.cancel();
        Thread thread = this.drainingThread;
        if (!this.drained && thread != null && thread.getState() == Thread.State.TIMED_WAITING) {
            thread.interrupt();
        }
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.getMessage(), this.drained ? 100 : 0);
    }

    public void run() {
        this.log.debug("Latching {}", (Object)this.getResourceName());
        Latch latch = this.latchableService.acquireLatch(this.latchMode);
        this.log.debug("Draining {}", (Object)this.getResourceName());
        this.drainingThread = Thread.currentThread();
        this.drained = DrainHelper.drain(latch, this.drainTimeoutSeconds, this.forceDrainTimeoutSeconds);
        this.drainingThread = null;
        if (!this.drained) {
            if (this.isCanceled()) {
                Thread.interrupted();
            }
            this.log.warn("The {} could not be drained. Aborting...", (Object)this.getResourceName());
            throw this.newDrainFailedException();
        }
        this.log.debug("Successfully drained the {}", (Object)this.getResourceName());
    }

    protected abstract String getMessage();

    protected abstract String getResourceName();

    protected abstract ServiceException newDrainFailedException();
}

