/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.botocss.BotocssStyles;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.condition.ConditionState;
import com.atlassian.plugin.webresource.condition.ConditionsCache;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.mail.BotocssStylesResolver;
import com.atlassian.stash.internal.plugin.SimpleServletContextFactory;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="botocssStylesResolver")
@Profiled
public class CachingBotocssStylesResolver
implements BotocssStylesResolver {
    private static final Logger log = LoggerFactory.getLogger(BotocssStylesResolver.class);
    private final LoadingCache<String, BotocssStyles> cache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<String, BotocssStyles>(){

        @Nonnull
        public BotocssStyles load(@Nonnull String moduleKey) throws Exception {
            return CachingBotocssStylesResolver.this.loadBotocssStylesForModuleKey(moduleKey);
        }
    });
    private final ResourceDependencyResolver resourceResolver;
    private final SimpleServletContextFactory servletContextFactory;

    @Autowired
    public CachingBotocssStylesResolver(ResourceDependencyResolver resourceResolver, SimpleServletContextFactory servletContextFactory) {
        this.resourceResolver = resourceResolver;
        this.servletContextFactory = servletContextFactory;
    }

    private void clearCache() {
        this.cache.invalidateAll();
    }

    public BotocssStyles getBotocssStylesForModuleKey(String moduleKey) {
        return (BotocssStyles)this.cache.getUnchecked((Object)moduleKey);
    }

    @EventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        this.clearCache();
    }

    @EventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        this.clearCache();
    }

    @Nonnull
    private BotocssStyles loadBotocssStylesForModuleKey(String moduleKey) {
        Iterable<InputStream> css = this.getStylesForModuleKey(moduleKey);
        try {
            return BotocssStyles.parse((String[])new String[]{IOUtils.toString((InputStream)new SequenceInputStream(Iterators.asEnumeration(css.iterator())))});
        }
        catch (IOException e) {
            log.debug("IOException when attempting to convert CSS to String", (Throwable)e);
            return BotocssStyles.parse((String[])new String[0]);
        }
    }

    private Iterable<InputStream> getStylesForModuleKey(String moduleKey) {
        return Chainable.chain((Iterable)this.resourceResolver.getDependencies(moduleKey, false, new ConditionState(), new ConditionsCache())).flatMap(this::getStylesForModuleDescriptor);
    }

    private Iterable<InputStream> getStylesForModuleDescriptor(WebResourceModuleDescriptor moduleDescriptor) {
        Predicate<ResourceDescriptor> cssResourcePredicate = descriptor -> descriptor != null && descriptor.getLocation().endsWith(".css");
        Function<ResourceDescriptor, InputStream> inputStreamForResourceDescriptor = rd -> this.getResourceStreamViaMinificationStrategy(moduleDescriptor.getPlugin(), (ResourceDescriptor)rd);
        return Chainable.chain((Iterable)moduleDescriptor.getResourceDescriptors()).filter(cssResourcePredicate).transform(inputStreamForResourceDescriptor).filter(Objects::nonNull);
    }

    private InputStream getResourceStreamViaMinificationStrategy(Plugin plugin, ResourceDescriptor resourceDescriptor) {
        String resourceLocation = resourceDescriptor.getLocation();
        InputStream resourceAsStream = this.getResourceAsStream(plugin, resourceDescriptor, this.minifiedLocationIfAvailable(resourceLocation));
        if (resourceAsStream != null) {
            return resourceAsStream;
        }
        return this.getResourceAsStream(plugin, resourceDescriptor, resourceLocation);
    }

    private InputStream getResourceAsStream(Plugin plugin, ResourceDescriptor resourceDescriptor, String resourceLocation) {
        String sourceParam = resourceDescriptor.getParameter("source");
        if ("webContextStatic".equalsIgnoreCase(sourceParam)) {
            return this.servletContextFactory.getServletContext().getResourceAsStream(resourceLocation);
        }
        return plugin.getResourceAsStream(resourceLocation);
    }

    private String minifiedLocationIfAvailable(String resourceLocation) {
        if (Boolean.getBoolean("atlassian.dev.mode") || resourceLocation.endsWith("-min.css") || resourceLocation.endsWith(".min.css")) {
            return resourceLocation;
        }
        return this.getMinifiedLocation(resourceLocation);
    }

    private String getMinifiedLocation(String location) {
        int lastDot = location.lastIndexOf(".");
        return location.substring(0, lastDot) + "-min" + location.substring(lastDot);
    }
}

