/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.license;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.license.IncompatibleLicenseChangeException;
import com.atlassian.bitbucket.license.InvalidLicenseException;
import com.atlassian.bitbucket.license.LicenseLimitException;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.license.DualLicense;
import com.atlassian.stash.internal.license.InternalLicenseService;
import com.atlassian.stash.internal.license.LicenseHelper;
import com.atlassian.stash.internal.license.LicensedUserCountCache;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.hazelcast.core.HazelcastInstance;
import java.security.Principal;
import java.util.HashSet;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=LicenseService.class)
@Service(value="licenseService")
@Transactional(propagation=Propagation.SUPPORTS)
public class LicenseServiceImpl
implements InternalLicenseService {
    private final HazelcastInstance hazelcast;
    private final I18nService i18nService;
    private final LicensedUserCountCache licensedUserCountCache;
    private final LicenseHelper licenseHelper;
    private final CachedReference<Option<DualLicense>> licenseReference;
    private final InternalPermissionService permissionService;
    private final ApplicationPropertiesService propertiesService;
    private final UserService userService;

    @Autowired
    public LicenseServiceImpl(LicenseHelper licenseHelper, @Lazy InternalPermissionService permissionService, InternalApplicationPropertiesService propertiesService, I18nService i18nService, LicensedUserCountCache licensedUserCountCache, UserService userService, CacheFactory cacheFactory, HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
        this.i18nService = i18nService;
        this.licenseHelper = licenseHelper;
        this.permissionService = permissionService;
        this.propertiesService = propertiesService;
        this.licensedUserCountCache = licensedUserCountCache;
        this.userService = userService;
        this.licenseReference = cacheFactory.getCachedReference(LicenseService.class, "BitbucketServerLicense", this::loadLicense, new CacheSettingsBuilder().remote().build());
    }

    @Unsecured(value="everyone needs access to this method")
    public boolean isPresent() {
        return this.get() != null;
    }

    @Unsecured(value="everyone needs access to this method")
    public BitbucketServerLicense get() {
        return (BitbucketServerLicense)((Option)this.licenseReference.get()).getOrNull();
    }

    @Unsecured(value="Access to the encrypted license is required by UPM")
    public String getAsString() {
        return (String)((Option)this.licenseReference.get()).map(DualLicense::getEncodedLicense).getOrNull();
    }

    @Unsecured(value="everyone needs access to this method")
    public int getLicensedUsersCount() {
        return this.licensedUserCountCache.getCount();
    }

    @Unsecured(value="everyone needs access to this method")
    public boolean canLogin(Principal principal) {
        if (principal instanceof StashUserAuthenticationToken) {
            principal = ((StashUserAuthenticationToken)principal).getPrincipal();
        }
        if (!(principal instanceof ApplicationUser)) {
            return false;
        }
        ApplicationUser user = (ApplicationUser)principal;
        return user.getType() == UserType.SERVICE || user.isActive() && this.isUserLicensed(user);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional(readOnly=true)
    public void validateCanLicenseUser(ApplicationUser user, Permission permission) throws LicenseLimitException {
        if (!Permission.LICENSED_USER.getInheritingPermissions().contains(permission)) {
            return;
        }
        BitbucketServerLicense license = this.get();
        if (license == null || license.isUnlimitedNumberOfUsers()) {
            return;
        }
        if (this.isUserLicensed(user)) {
            return;
        }
        int licenseLimit = license.getMaximumNumberOfUsers();
        int licenseCount = this.permissionService.getUsersWithPermission(Permission.LICENSED_USER).size();
        if (licenseCount < licenseLimit) {
            return;
        }
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.license.userlimit", new Object[]{user.getDisplayName(), licenseLimit});
        throw new LicenseLimitException(message);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional(readOnly=true)
    public void validateCanLicenseGroup(String group, Permission permission) throws LicenseLimitException {
        Page users;
        if (!Permission.LICENSED_USER.getInheritingPermissions().contains(permission)) {
            return;
        }
        BitbucketServerLicense license = this.get();
        if (license == null || license.isUnlimitedNumberOfUsers()) {
            return;
        }
        if (this.permissionService.hasGlobalGroupPermission(Permission.LICENSED_USER, group)) {
            return;
        }
        int licenseLimit = license.getMaximumNumberOfUsers();
        HashSet<String> licensedUsers = new HashSet<String>();
        licensedUsers.addAll(this.permissionService.getUsersWithPermission(Permission.LICENSED_USER));
        PageRequestImpl request = new PageRequestImpl(0, 1000);
        do {
            users = this.userService.findUsersByGroup(group, (PageRequest)request);
            for (ApplicationUser user : users.getValues()) {
                licensedUsers.add(IdentifierUtils.toLowerCase((String)user.getName()));
                if (licensedUsers.size() <= licenseLimit) continue;
                KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.license.grouplimit", new Object[]{group, licenseLimit});
                throw new LicenseLimitException(message);
            }
        } while ((request = users.getNextPageRequest()) != null);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional(readOnly=true)
    public void validateCanAddUserToGroup(String name, String group) {
        if (!this.permissionService.hasGlobalGroupPermission(Permission.LICENSED_USER, group)) {
            return;
        }
        ApplicationUser user = this.userService.getUserByName(name, true);
        if (user != null) {
            this.validateCanLicenseUser(user, Permission.LICENSED_USER);
        }
    }

    @Unsecured(value="everyone needs access to this method")
    public KeyedMessage getValidityMessage() {
        return this.getLicenseValidityMessage(this.get());
    }

    @Unsecured(value="everyone needs access to this method")
    public KeyedMessage getOverLimitMessage() {
        BitbucketServerLicense license = this.get();
        if (license != null && !license.isUnlimitedNumberOfUsers()) {
            int licenseLimit = license.getMaximumNumberOfUsers();
            int licenseCount = this.getLicensedUsersCount();
            if (licenseCount > licenseLimit) {
                return this.i18nService.createKeyedMessage("bitbucket.license.over.limit", new Object[0]);
            }
        }
        return null;
    }

    @Unsecured(value="everyone needs access to this method")
    public KeyedMessage getStatus() {
        KeyedMessage message = this.getValidityMessage();
        if (message == null) {
            message = this.getOverLimitMessage();
        }
        return message;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BitbucketServerLicense set(@Nonnull String encoded) {
        return this.set(encoded, true);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BitbucketServerLicense setUnvalidated(@Nonnull String encoded) {
        return this.set(encoded, false);
    }

    private BitbucketServerLicense decodeLicense(String license) throws InvalidLicenseException {
        try {
            DualLicense bitbucketLicense = this.licenseHelper.decode(license);
            if (bitbucketLicense == null) {
                throw new InvalidLicenseException(this.i18nService.createKeyedMessage("bitbucket.license.not.included", new Object[]{ApplicationConstants.PRODUCT_NAME}));
            }
            return bitbucketLicense;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLicenseException(this.i18nService.createKeyedMessage("bitbucket.license.invalid", new Object[0]));
        }
    }

    private KeyedMessage getLicenseValidityMessage(BitbucketServerLicense license) {
        if (license == null) {
            return this.i18nService.createKeyedMessage("bitbucket.license.no.license", new Object[0]);
        }
        if (this.propertiesService.getMode() == ApplicationMode.MIRROR) {
            return null;
        }
        if (license.isExpired()) {
            if (license.isEvaluation()) {
                return this.i18nService.createKeyedMessage("bitbucket.license.evaluation.expired", new Object[0]);
            }
            return this.i18nService.createKeyedMessage("bitbucket.license.expired", new Object[0]);
        }
        if (license.getMaintenanceExpiryDate() != null && this.propertiesService.getBuildTimestamp() != null && this.propertiesService.getBuildTimestamp().after(license.getMaintenanceExpiryDate())) {
            return this.i18nService.createKeyedMessage("bitbucket.license.unsupported.upgrade", new Object[]{ApplicationConstants.PRODUCT_NAME});
        }
        return null;
    }

    private boolean isUserLicensed(ApplicationUser user) {
        return this.permissionService.hasGlobalPermission(user, Permission.LICENSED_USER);
    }

    private Option<DualLicense> loadLicense() {
        return Option.option((Object)this.licenseHelper.getDecoded());
    }

    private BitbucketServerLicense set(@Nonnull String encoded, boolean validate) {
        KeyedMessage validityMessage;
        if (StringUtils.isEmpty((CharSequence)encoded)) {
            throw new InvalidLicenseException(this.i18nService.createKeyedMessage("bitbucket.license.empty", new Object[0]));
        }
        BitbucketServerLicense license = this.decodeLicense(encoded);
        if (validate && (validityMessage = this.getLicenseValidityMessage(license)) != null) {
            throw new InvalidLicenseException(validityMessage);
        }
        if (!license.isClusteringEnabled() && this.hazelcast.getCluster().getMembers().size() > 1) {
            throw new IncompatibleLicenseChangeException(this.i18nService.createKeyedMessage("bitbucket.license.not.clustered", new Object[0]));
        }
        this.licenseHelper.set(encoded);
        SpringTransactionUtils.invokeAfterCommit(() -> this.licenseReference.reset());
        return license;
    }
}

