/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.atlassian.stash.internal.config.AbstractConfigurationAmendment;
import com.atlassian.stash.internal.config.Clock;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.annotation.Nonnull;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class RemovePropertiesAmendment
extends AbstractConfigurationAmendment {
    protected final Set<String> properties;

    public RemovePropertiesAmendment(@Nonnull Clock clock, @Nonnull Set<String> properties) {
        super(clock);
        this.properties = (Set)Preconditions.checkNotNull(properties);
    }

    @VisibleForTesting
    public static String formatComment(@Nonnull String line, @Nonnull Clock clock) {
        return String.format("# %s removed by unattended setup on %s", RemovePropertiesAmendment.getPropertyKey(line), ISODateTimeFormat.dateTime().print((ReadableInstant)clock.now()));
    }

    @Override
    public boolean isAmendable(@Nonnull String line) {
        return this.isAmendableProperty(line);
    }

    @Override
    public void amend(@Nonnull Writer writer, @Nonnull String line) throws IOException {
        this.writeLine(writer, RemovePropertiesAmendment.formatComment(line, this.getClock()));
    }

    protected boolean isAmendableProperty(@Nonnull String line) {
        return this.properties.contains(RemovePropertiesAmendment.getPropertyKey(line));
    }
}

