/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.fugue.Option;
import com.atlassian.stash.internal.config.Clock;
import com.atlassian.stash.internal.config.DataSourcePropertySerializer;
import com.atlassian.stash.internal.config.RemovePropertiesAmendment;
import com.atlassian.stash.internal.db.DatabaseConstants;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class DataSourceConfigurationAmendment
extends RemovePropertiesAmendment {
    private final DataSourceConfiguration dataSourceConfig;
    private final Option<String> message;
    private final ApplicationUser user;
    private boolean isOutputAmended;

    public DataSourceConfigurationAmendment(@Nonnull DataSourceConfiguration dataSourceConfig, @Nullable Option<String> message, @Nonnull Clock clock, @Nullable ApplicationUser user) {
        super(clock, DatabaseConstants.PROPS_JDBC);
        this.dataSourceConfig = (DataSourceConfiguration)Preconditions.checkNotNull((Object)dataSourceConfig);
        this.message = message;
        this.user = user;
    }

    @Override
    public boolean isAmendable(@Nonnull String line) {
        return this.isCommentBlockLine(line) || this.isAmendableProperty(line);
    }

    @Override
    public void amend(@Nonnull Writer writer, @Nonnull String line) throws IOException {
        if (!this.isOutputAmended) {
            this.isOutputAmended = true;
            this.addPropertiesSection(writer);
        }
        if (this.isAmendableProperty(line)) {
            this.commentOut(line, writer);
        }
    }

    @Override
    public void finalize(@Nonnull Writer writer) throws IOException {
        if (!this.isOutputAmended) {
            this.addPropertiesSection(writer);
        }
    }

    private void addPropertiesSection(Writer writer) throws IOException {
        this.writeCommentBlock(writer);
        this.writePropertyStrings(writer);
    }

    private void commentOut(String line, Writer writer) throws IOException {
        this.writeLine(writer, String.format("# %s", line));
    }

    private boolean isCommentBlockLine(String line) {
        return line.trim().startsWith("#>");
    }

    private void writePropertyStrings(Writer writer) throws IOException {
        DataSourcePropertySerializer serializer = new DataSourcePropertySerializer(this.dataSourceConfig);
        serializer.writeTo(writer);
    }

    private void writeCommentBlock(Writer writer) throws IOException {
        this.writeLine(writer, "#>*******************************************************");
        if (this.message.isDefined()) {
            this.writeLine(writer, "#> " + (String)this.message.get());
        }
        this.writeLine(writer, this.formatUpdateTimestamp());
        this.writeLine(writer, "#>*******************************************************");
    }

    private String formatUpdateTimestamp() {
        StringBuilder builder = new StringBuilder("#> Updated");
        if (this.user != null) {
            builder.append(" by ").append(this.user.getDisplayName());
        }
        builder.append(" on ").append(ISODateTimeFormat.dateTime().print((ReadableInstant)this.getClock().now()));
        return builder.toString();
    }
}

