/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.event.commit.CommitDiscussionParticipantsUpdatedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommitCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.commit.CommitDiscussionDao;
import com.atlassian.stash.internal.commit.CommitDiscussionParticipantDao;
import com.atlassian.stash.internal.commit.CommitDiscussionRequest;
import com.atlassian.stash.internal.commit.CommitDiscussionSource;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionParticipant;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcherService;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="commitDiscussionSource")
public class DefaultCommitDiscussionSource
implements CommitDiscussionSource {
    private final AuthenticationContext authenticationContext;
    private final CommitDiscussionDao discussionDao;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final CommitDiscussionParticipantDao participantDao;
    private final ScmService scmService;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;
    private final InternalWatcherService watcherService;

    @Autowired
    public DefaultCommitDiscussionSource(AuthenticationContext authenticationContext, CommitDiscussionDao discussionDao, EventPublisher eventPublisher, I18nService i18nService, CommitDiscussionParticipantDao participantDao, ScmService scmService, PlatformTransactionManager transactionManager, UserService userService, InternalWatcherService watcherService) {
        this.authenticationContext = authenticationContext;
        this.discussionDao = discussionDao;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.participantDao = participantDao;
        this.scmService = scmService;
        this.userService = userService;
        this.watcherService = watcherService;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Override
    public InternalCommitDiscussion get(@Nonnull CommitDiscussionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        InternalCommitDiscussion discussion = this.doGet(request);
        if (discussion != null && request.isParticipate()) {
            this.maybeAddParticipant(discussion);
        }
        return discussion;
    }

    private void addParticipant(InternalCommitDiscussion discussion, ApplicationUser user) {
        this.participantDao.create((Object)((InternalCommitDiscussionParticipant.Builder)new InternalCommitDiscussionParticipant.Builder(discussion).user(InternalConverter.convertToInternalUser((ApplicationUser)user))).build());
        this.watcherService.addUserAsWatcher((InternalWatchable)discussion, user);
        this.eventPublisher.publish((Object)new CommitDiscussionParticipantsUpdatedEvent((Object)this, (CommitDiscussion)discussion, Collections.singleton(user), Collections.emptySet()));
    }

    private void maybeAddParticipant(InternalCommitDiscussion discussion) {
        this.maybeAddParticipant(discussion, this.authenticationContext.getCurrentUser());
    }

    private void maybeAddParticipant(InternalCommitDiscussion discussion, ApplicationUser user) {
        InternalCommitDiscussionParticipant participant = this.participantDao.findByDiscussionAndUser(discussion.getId(), user.getId());
        if (participant == null) {
            this.addParticipant(discussion, user);
        }
    }

    private InternalCommitDiscussion doGet(CommitDiscussionRequest request) {
        String commitId = request.getCommitId();
        Repository repository = request.getRepository();
        InternalCommitDiscussion discussion = this.discussionDao.findByRepositoryAndCommit(repository.getId(), commitId);
        if (request.isCreate() && discussion == null) {
            Commit commit = (Commit)this.scmService.getCommandFactory(repository).commit(((CommitCommandParameters.Builder)new CommitCommandParameters.Builder().commitId(commitId)).build()).call();
            if (commit == null) {
                throw new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.service.repository.commitnotfound", new Object[]{repository.getName(), commitId}), commitId);
            }
            discussion = this.discussionDao.findByRepositoryAndCommit(repository.getId(), commit.getId());
            if (discussion == null) {
                try {
                    ApplicationUser author = this.findAuthor(commit);
                    discussion = this.createDiscussion(repository, commit, author);
                }
                catch (RuntimeException e) {
                    if (this.isDataIntegrityViolation(e) && (discussion = this.discussionDao.findByRepositoryAndCommit(repository.getId(), commit.getId())) != null) {
                        return discussion;
                    }
                    throw e;
                }
            }
        }
        return discussion;
    }

    private InternalCommitDiscussion createDiscussion(final @Nonnull Repository repository, final @Nonnull Commit commit, final @Nullable ApplicationUser author) {
        return (InternalCommitDiscussion)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<InternalCommitDiscussion>(){

            public InternalCommitDiscussion doInTransaction(TransactionStatus transactionStatus) {
                InternalCommitDiscussion discussion = (InternalCommitDiscussion)DefaultCommitDiscussionSource.this.discussionDao.create((Object)new InternalCommitDiscussion.Builder(InternalConverter.convertToInternalRepository((Repository)repository), commit.getId()).parents(commit.getParents()).build());
                if (author != null) {
                    DefaultCommitDiscussionSource.this.addParticipant(discussion, author);
                }
                return discussion;
            }
        });
    }

    private ApplicationUser findAuthor(Commit commit) {
        String emailAddress = commit.getAuthor().getEmailAddress();
        return StringUtils.isNotBlank((CharSequence)emailAddress) ? this.userService.findUserByNameOrEmail(emailAddress) : null;
    }

    private boolean isDataIntegrityViolation(RuntimeException e) {
        return Iterables.any((Iterable)Throwables.getCausalChain((Throwable)e), (Predicate)Predicates.instanceOf(DataIntegrityViolationException.class));
    }
}

