/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.check;

import com.atlassian.bitbucket.scm.ScmRequest;
import com.atlassian.bitbucket.scm.ScmRequestCheck;
import com.atlassian.bitbucket.scm.ScmRequestCheckModuleDescriptor;
import com.atlassian.bitbucket.scm.ScmRequestCheckService;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.check.LicensingCheck;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=ScmRequestCheckService.class)
@Service(value="scmRequestCheckService")
@Transactional(propagation=Propagation.SUPPORTS)
public class ScmRequestCheckServiceImpl
extends AbstractService
implements ScmRequestCheckService {
    private final PluginAccessor pluginAccessor;
    private final LicensingCheck licensingCheck;

    @Autowired
    public ScmRequestCheckServiceImpl(PluginAccessor pluginAccessor, LicensingCheck licensingCheck) {
        this.pluginAccessor = pluginAccessor;
        this.licensingCheck = licensingCheck;
    }

    @Unsecured(value="Validating whether an SCM request can proceed does not require a specific permission")
    public boolean checkActionAllowed(ScmRequest request) throws IOException {
        Iterable requestChecks = Stream.concat(Stream.of(this.licensingCheck), ModuleDescriptorUtils.toSortedModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(ScmRequestCheckModuleDescriptor.class))).collect(Collectors.toList());
        for (ScmRequestCheck check : requestChecks) {
            if (check.check(request)) continue;
            return false;
        }
        return true;
    }
}

