/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandler;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandlerModuleDescriptor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.plugin.PluginAccessor;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pluginHttpAuthenticationHandler")
public class PluginHttpAuthenticationHandler
implements HttpAuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(PluginHttpAuthenticationHandler.class);
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginHttpAuthenticationHandler(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public ApplicationUser authenticate(@Nonnull HttpAuthenticationContext context) {
        for (HttpAuthenticationHandler handler : this.getHandlers()) {
            String handlerName = handler.getClass().getName();
            Timer ignored = TimerUtils.start((String)(handlerName + ".authentication"));
            Throwable throwable = null;
            try {
                log.debug("authenticate - trying handler {}", (Object)handlerName);
                ApplicationUser user = handler.authenticate(context);
                if (user == null) continue;
                log.debug("authenticate - handler {} authenticated user {}", (Object)handlerName, (Object)user.getName());
                ApplicationUser applicationUser = user;
                return applicationUser;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        log.debug("authenticate - none of the plugins handled authentication");
        return null;
    }

    public void validateAuthentication(@Nonnull HttpAuthenticationContext context) {
        for (HttpAuthenticationHandler handler : this.getHandlers()) {
            String handlerName = handler.getClass().getName();
            try {
                Timer ignored = TimerUtils.start((String)(handlerName + ".validateAuthentication"));
                Throwable throwable = null;
                try {
                    log.trace("validateAuthentication - Calling handler {}.validateAuthentication", (Object)handlerName);
                    handler.validateAuthentication(context);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
            catch (RuntimeException e) {
                log.debug("{} {} failed validation", new Object[]{HttpAuthenticationHandler.class.getSimpleName(), handlerName, e});
                throw e;
            }
        }
    }

    private Iterable<HttpAuthenticationHandler> getHandlers() {
        return ModuleDescriptorUtils.toSortedModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(HttpAuthenticationHandlerModuleDescriptor.class)).collect(Collectors.toList());
    }
}

