/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.bitbucket.audit.AuditEntry;
import com.atlassian.bitbucket.audit.AuditEntryBuilder;
import com.atlassian.bitbucket.audit.Priority;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.auth.AbstractAuthenticationEvent;
import com.atlassian.bitbucket.event.auth.AuthenticationFailureEvent;
import com.atlassian.bitbucket.event.auth.AuthenticationSuccessEvent;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.audit.AbstractAuditEventListener;
import com.atlassian.stash.internal.audit.AuditEntryLoggingService;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="authenticationEventListener")
public class AuthenticationEventListener
extends AbstractAuditEventListener {
    private final UserService userService;

    @Autowired
    public AuthenticationEventListener(AuditEntryLoggingService auditLoggingService, RequestManager requestManager, AuthenticationContext authContext, EventPublisher eventPublisher, UserService userService) {
        super(auditLoggingService, requestManager, authContext, eventPublisher);
        this.userService = userService;
    }

    @EventListener
    public void onAuthenticationFailure(AuthenticationFailureEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuthenticationAuditEntryBuilder((AbstractAuthenticationEvent)event).details(this.toDetailsString(event)).build();
        this.publish(event, auditEntry, Collections.emptySet(), Priority.HIGH);
    }

    @EventListener
    public void onAuthenticationSuccess(AuthenticationSuccessEvent event) throws Exception {
        AuditEntry auditEntry = this.createAuthenticationAuditEntryBuilder((AbstractAuthenticationEvent)event).details(this.toDetailsString(event)).build();
        this.publish(event, auditEntry, Collections.emptySet(), Priority.LOW);
    }

    private ImmutableMap.Builder<String, String> createDetailsBuilder(AbstractAuthenticationEvent event) {
        return new ImmutableMap.Builder().put((Object)"authentication-method", (Object)event.getAuthenticationMethod());
    }

    private AuditEntryBuilder createAuthenticationAuditEntryBuilder(AbstractAuthenticationEvent event) {
        AuditEntryBuilder builder = this.createAuditEntryBuilder((ApplicationEvent)event);
        if (event.getUsername() == null) {
            builder.target("<anonymous>");
        } else {
            ApplicationUser user = event.getUser();
            if (user == null || !user.getName().equals(event.getUsername())) {
                user = this.userService.getUserByName(event.getUsername(), true);
            }
            builder.user(user);
            builder.target(event.getUsername());
        }
        return builder;
    }

    private String toDetailsString(AuthenticationFailureEvent event) throws IOException {
        ImmutableMap.Builder<String, String> detailsBuilder = this.createDetailsBuilder((AbstractAuthenticationEvent)event);
        AuthenticationException exception = event.getException();
        if (exception != null && exception.getLocalizedMessage() != null) {
            detailsBuilder.put((Object)"error", (Object)exception.getLocalizedMessage());
        }
        return this.convertToJsonString(detailsBuilder.build());
    }

    private String toDetailsString(AuthenticationSuccessEvent event) throws IOException {
        ImmutableMap.Builder<String, String> detailsBuilder = this.createDetailsBuilder((AbstractAuthenticationEvent)event);
        if (StringUtils.isNotBlank((CharSequence)event.getTokenDetails())) {
            detailsBuilder.put((Object)"tokenDetails", (Object)event.getTokenDetails());
        }
        return this.convertToJsonString(detailsBuilder.build());
    }
}

