/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.util;

import com.atlassian.stash.internal.util.LatchedInvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import org.springframework.core.InfrastructureProxy;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionAwareLatchedInvocationHandler
extends LatchedInvocationHandler
implements InfrastructureProxy {
    private final Object transactionDelegate;

    public TransactionAwareLatchedInvocationHandler(Object targetDelegate, CountDownLatch latch, Object transactionDelegate) {
        super(targetDelegate, latch);
        this.transactionDelegate = transactionDelegate;
    }

    public Object getWrappedObject() {
        Object delegate = this.getDelegate(null);
        return delegate instanceof InfrastructureProxy ? ((InfrastructureProxy)delegate).getWrappedObject() : delegate;
    }

    @Override
    protected Object getDelegate(Method method) {
        if (method != null && method.getDeclaringClass() == InfrastructureProxy.class) {
            return this;
        }
        return this.isInTransaction() ? this.transactionDelegate : super.getDelegate(method);
    }

    @Override
    protected boolean isLatched(Method method) {
        return super.isLatched(method) && !this.isInTransaction();
    }

    private boolean isInTransaction() {
        return TransactionSynchronizationManager.hasResource((Object)this.transactionDelegate);
    }
}

